<?php
// This file was auto-generated from sdk-root/src/data/bedrock-agent-runtime/2023-07-26/api-2.json
return [ 'version' => '2.0', 'metadata' => [ 'apiVersion' => '2023-07-26', 'auth' => [ 'aws.auth#sigv4', ], 'endpointPrefix' => 'bedrock-agent-runtime', 'protocol' => 'rest-json', 'protocols' => [ 'rest-json', ], 'serviceFullName' => 'Agents for Amazon Bedrock Runtime', 'serviceId' => 'Bedrock Agent Runtime', 'signatureVersion' => 'v4', 'signingName' => 'bedrock', 'uid' => 'bedrock-agent-runtime-2023-07-26', ], 'operations' => [ 'CreateInvocation' => [ 'name' => 'CreateInvocation', 'http' => [ 'method' => 'PUT', 'requestUri' => '/sessions/{sessionIdentifier}/invocations/', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateInvocationRequest', ], 'output' => [ 'shape' => 'CreateInvocationResponse', ], 'errors' => [ [ 'shape' => 'ConflictException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], 'idempotent' => true, ], 'CreateSession' => [ 'name' => 'CreateSession', 'http' => [ 'method' => 'PUT', 'requestUri' => '/sessions/', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateSessionRequest', ], 'output' => [ 'shape' => 'CreateSessionResponse', ], 'errors' => [ [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], 'idempotent' => true, ], 'DeleteAgentMemory' => [ 'name' => 'DeleteAgentMemory', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/agents/{agentId}/agentAliases/{agentAliasId}/memories', 'responseCode' => 202, ], 'input' => [ 'shape' => 'DeleteAgentMemoryRequest', ], 'output' => [ 'shape' => 'DeleteAgentMemoryResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'DependencyFailedException', ], [ 'shape' => 'BadGatewayException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], 'idempotent' => true, ], 'DeleteSession' => [ 'name' => 'DeleteSession', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/sessions/{sessionIdentifier}/', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteSessionRequest', ], 'output' => [ 'shape' => 'DeleteSessionResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], 'idempotent' => true, ], 'EndSession' => [ 'name' => 'EndSession', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/sessions/{sessionIdentifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'EndSessionRequest', ], 'output' => [ 'shape' => 'EndSessionResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], 'idempotent' => true, ], 'GenerateQuery' => [ 'name' => 'GenerateQuery', 'http' => [ 'method' => 'POST', 'requestUri' => '/generateQuery', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GenerateQueryRequest', ], 'output' => [ 'shape' => 'GenerateQueryResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'DependencyFailedException', ], [ 'shape' => 'BadGatewayException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], 'readonly' => true, ], 'GetAgentMemory' => [ 'name' => 'GetAgentMemory', 'http' => [ 'method' => 'GET', 'requestUri' => '/agents/{agentId}/agentAliases/{agentAliasId}/memories', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetAgentMemoryRequest', ], 'output' => [ 'shape' => 'GetAgentMemoryResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'DependencyFailedException', ], [ 'shape' => 'BadGatewayException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], 'readonly' => true, ], 'GetExecutionFlowSnapshot' => [ 'name' => 'GetExecutionFlowSnapshot', 'http' => [ 'method' => 'GET', 'requestUri' => '/flows/{flowIdentifier}/aliases/{flowAliasIdentifier}/executions/{executionIdentifier}/flowsnapshot', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetExecutionFlowSnapshotRequest', ], 'output' => [ 'shape' => 'GetExecutionFlowSnapshotResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], 'readonly' => true, ], 'GetFlowExecution' => [ 'name' => 'GetFlowExecution', 'http' => [ 'method' => 'GET', 'requestUri' => '/flows/{flowIdentifier}/aliases/{flowAliasIdentifier}/executions/{executionIdentifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetFlowExecutionRequest', ], 'output' => [ 'shape' => 'GetFlowExecutionResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], 'readonly' => true, ], 'GetInvocationStep' => [ 'name' => 'GetInvocationStep', 'http' => [ 'method' => 'POST', 'requestUri' => '/sessions/{sessionIdentifier}/invocationSteps/{invocationStepId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetInvocationStepRequest', ], 'output' => [ 'shape' => 'GetInvocationStepResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], 'readonly' => true, ], 'GetSession' => [ 'name' => 'GetSession', 'http' => [ 'method' => 'GET', 'requestUri' => '/sessions/{sessionIdentifier}/', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetSessionRequest', ], 'output' => [ 'shape' => 'GetSessionResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], 'readonly' => true, ], 'InvokeAgent' => [ 'name' => 'InvokeAgent', 'http' => [ 'method' => 'POST', 'requestUri' => '/agents/{agentId}/agentAliases/{agentAliasId}/sessions/{sessionId}/text', 'responseCode' => 200, ], 'input' => [ 'shape' => 'InvokeAgentRequest', ], 'output' => [ 'shape' => 'InvokeAgentResponse', ], 'errors' => [ [ 'shape' => 'ModelNotReadyException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'DependencyFailedException', ], [ 'shape' => 'BadGatewayException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], ], 'InvokeFlow' => [ 'name' => 'InvokeFlow', 'http' => [ 'method' => 'POST', 'requestUri' => '/flows/{flowIdentifier}/aliases/{flowAliasIdentifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'InvokeFlowRequest', ], 'output' => [ 'shape' => 'InvokeFlowResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'DependencyFailedException', ], [ 'shape' => 'BadGatewayException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], ], 'InvokeInlineAgent' => [ 'name' => 'InvokeInlineAgent', 'http' => [ 'method' => 'POST', 'requestUri' => '/agents/{sessionId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'InvokeInlineAgentRequest', ], 'output' => [ 'shape' => 'InvokeInlineAgentResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'DependencyFailedException', ], [ 'shape' => 'BadGatewayException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], ], 'ListFlowExecutionEvents' => [ 'name' => 'ListFlowExecutionEvents', 'http' => [ 'method' => 'GET', 'requestUri' => '/flows/{flowIdentifier}/aliases/{flowAliasIdentifier}/executions/{executionIdentifier}/events', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListFlowExecutionEventsRequest', ], 'output' => [ 'shape' => 'ListFlowExecutionEventsResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], 'readonly' => true, ], 'ListFlowExecutions' => [ 'name' => 'ListFlowExecutions', 'http' => [ 'method' => 'GET', 'requestUri' => '/flows/{flowIdentifier}/executions', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListFlowExecutionsRequest', ], 'output' => [ 'shape' => 'ListFlowExecutionsResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], 'readonly' => true, ], 'ListInvocationSteps' => [ 'name' => 'ListInvocationSteps', 'http' => [ 'method' => 'POST', 'requestUri' => '/sessions/{sessionIdentifier}/invocationSteps/', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListInvocationStepsRequest', ], 'output' => [ 'shape' => 'ListInvocationStepsResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], 'readonly' => true, ], 'ListInvocations' => [ 'name' => 'ListInvocations', 'http' => [ 'method' => 'POST', 'requestUri' => '/sessions/{sessionIdentifier}/invocations/', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListInvocationsRequest', ], 'output' => [ 'shape' => 'ListInvocationsResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], 'readonly' => true, ], 'ListSessions' => [ 'name' => 'ListSessions', 'http' => [ 'method' => 'POST', 'requestUri' => '/sessions/', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListSessionsRequest', ], 'output' => [ 'shape' => 'ListSessionsResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], 'readonly' => true, ], 'ListTagsForResource' => [ 'name' => 'ListTagsForResource', 'http' => [ 'method' => 'GET', 'requestUri' => '/tags/{resourceArn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListTagsForResourceRequest', ], 'output' => [ 'shape' => 'ListTagsForResourceResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], 'readonly' => true, ], 'OptimizePrompt' => [ 'name' => 'OptimizePrompt', 'http' => [ 'method' => 'POST', 'requestUri' => '/optimize-prompt', 'responseCode' => 200, ], 'input' => [ 'shape' => 'OptimizePromptRequest', ], 'output' => [ 'shape' => 'OptimizePromptResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'DependencyFailedException', ], [ 'shape' => 'BadGatewayException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'PutInvocationStep' => [ 'name' => 'PutInvocationStep', 'http' => [ 'method' => 'PUT', 'requestUri' => '/sessions/{sessionIdentifier}/invocationSteps/', 'responseCode' => 201, ], 'input' => [ 'shape' => 'PutInvocationStepRequest', ], 'output' => [ 'shape' => 'PutInvocationStepResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], 'idempotent' => true, ], 'Rerank' => [ 'name' => 'Rerank', 'http' => [ 'method' => 'POST', 'requestUri' => '/rerank', 'responseCode' => 200, ], 'input' => [ 'shape' => 'RerankRequest', ], 'output' => [ 'shape' => 'RerankResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'DependencyFailedException', ], [ 'shape' => 'BadGatewayException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], ], 'Retrieve' => [ 'name' => 'Retrieve', 'http' => [ 'method' => 'POST', 'requestUri' => '/knowledgebases/{knowledgeBaseId}/retrieve', 'responseCode' => 200, ], 'input' => [ 'shape' => 'RetrieveRequest', ], 'output' => [ 'shape' => 'RetrieveResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'DependencyFailedException', ], [ 'shape' => 'BadGatewayException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], 'readonly' => true, ], 'RetrieveAndGenerate' => [ 'name' => 'RetrieveAndGenerate', 'http' => [ 'method' => 'POST', 'requestUri' => '/retrieveAndGenerate', 'responseCode' => 200, ], 'input' => [ 'shape' => 'RetrieveAndGenerateRequest', ], 'output' => [ 'shape' => 'RetrieveAndGenerateResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'DependencyFailedException', ], [ 'shape' => 'BadGatewayException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], ], 'RetrieveAndGenerateStream' => [ 'name' => 'RetrieveAndGenerateStream', 'http' => [ 'method' => 'POST', 'requestUri' => '/retrieveAndGenerateStream', 'responseCode' => 200, ], 'input' => [ 'shape' => 'RetrieveAndGenerateStreamRequest', ], 'output' => [ 'shape' => 'RetrieveAndGenerateStreamResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'DependencyFailedException', ], [ 'shape' => 'BadGatewayException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], ], 'StartFlowExecution' => [ 'name' => 'StartFlowExecution', 'http' => [ 'method' => 'POST', 'requestUri' => '/flows/{flowIdentifier}/aliases/{flowAliasIdentifier}/executions', 'responseCode' => 200, ], 'input' => [ 'shape' => 'StartFlowExecutionRequest', ], 'output' => [ 'shape' => 'StartFlowExecutionResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'DependencyFailedException', ], [ 'shape' => 'BadGatewayException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], ], 'StopFlowExecution' => [ 'name' => 'StopFlowExecution', 'http' => [ 'method' => 'POST', 'requestUri' => '/flows/{flowIdentifier}/aliases/{flowAliasIdentifier}/executions/{executionIdentifier}/stop', 'responseCode' => 200, ], 'input' => [ 'shape' => 'StopFlowExecutionRequest', ], 'output' => [ 'shape' => 'StopFlowExecutionResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'DependencyFailedException', ], [ 'shape' => 'BadGatewayException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'TagResource' => [ 'name' => 'TagResource', 'http' => [ 'method' => 'POST', 'requestUri' => '/tags/{resourceArn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'TagResourceRequest', ], 'output' => [ 'shape' => 'TagResourceResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], ], 'UntagResource' => [ 'name' => 'UntagResource', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/tags/{resourceArn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UntagResourceRequest', ], 'output' => [ 'shape' => 'UntagResourceResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], 'idempotent' => true, ], 'UpdateSession' => [ 'name' => 'UpdateSession', 'http' => [ 'method' => 'PUT', 'requestUri' => '/sessions/{sessionIdentifier}/', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateSessionRequest', ], 'output' => [ 'shape' => 'UpdateSessionResponse', ], 'errors' => [ [ 'shape' => 'ConflictException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], 'idempotent' => true, ], ], 'shapes' => [ 'APISchema' => [ 'type' => 'structure', 'members' => [ 's3' => [ 'shape' => 'S3Identifier', ], 'payload' => [ 'shape' => 'Payload', ], ], 'union' => true, ], 'AWSResourceARN' => [ 'type' => 'string', 'max' => 2048, 'min' => 0, 'pattern' => 'arn:aws(-[^:]+)?:bedrock:[a-z0-9-]{1,20}:[0-9]{12}:agent/[0-9a-zA-Z]{10}', ], 'AccessDeniedException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'NonBlankString', ], ], 'error' => [ 'httpStatusCode' => 403, 'senderFault' => true, ], 'exception' => true, ], 'ActionGroupExecutor' => [ 'type' => 'structure', 'members' => [ 'lambda' => [ 'shape' => 'LambdaResourceArn', ], 'customControl' => [ 'shape' => 'CustomControlMethod', ], ], 'union' => true, ], 'ActionGroupInvocationInput' => [ 'type' => 'structure', 'members' => [ 'actionGroupName' => [ 'shape' => 'ActionGroupName', ], 'verb' => [ 'shape' => 'Verb', ], 'apiPath' => [ 'shape' => 'ApiPath', ], 'parameters' => [ 'shape' => 'Parameters', ], 'requestBody' => [ 'shape' => 'RequestBody', ], 'function' => [ 'shape' => 'Function', ], 'executionType' => [ 'shape' => 'ExecutionType', ], 'invocationId' => [ 'shape' => 'String', ], ], ], 'ActionGroupInvocationOutput' => [ 'type' => 'structure', 'members' => [ 'text' => [ 'shape' => 'ActionGroupOutputString', ], 'metadata' => [ 'shape' => 'Metadata', ], ], ], 'ActionGroupName' => [ 'type' => 'string', 'sensitive' => true, ], 'ActionGroupOutputString' => [ 'type' => 'string', 'sensitive' => true, ], 'ActionGroupSignature' => [ 'type' => 'string', 'enum' => [ 'AMAZON.UserInput', 'AMAZON.CodeInterpreter', 'ANTHROPIC.Computer', 'ANTHROPIC.Bash', 'ANTHROPIC.TextEditor', ], ], 'ActionGroupSignatureParams' => [ 'type' => 'map', 'key' => [ 'shape' => 'ActionGroupSignatureParamsKeyString', ], 'value' => [ 'shape' => 'ActionGroupSignatureParamsValueString', ], ], 'ActionGroupSignatureParamsKeyString' => [ 'type' => 'string', 'max' => 100, 'min' => 0, ], 'ActionGroupSignatureParamsValueString' => [ 'type' => 'string', 'max' => 100, 'min' => 0, ], 'ActionInvocationType' => [ 'type' => 'string', 'enum' => [ 'RESULT', 'USER_CONFIRMATION', 'USER_CONFIRMATION_AND_RESULT', ], ], 'AdditionalModelRequestFields' => [ 'type' => 'map', 'key' => [ 'shape' => 'AdditionalModelRequestFieldsKey', ], 'value' => [ 'shape' => 'AdditionalModelRequestFieldsValue', ], ], 'AdditionalModelRequestFieldsKey' => [ 'type' => 'string', 'max' => 100, 'min' => 1, ], 'AdditionalModelRequestFieldsValue' => [ 'type' => 'structure', 'members' => [], 'document' => true, ], 'AgentActionGroup' => [ 'type' => 'structure', 'required' => [ 'actionGroupName', ], 'members' => [ 'actionGroupName' => [ 'shape' => 'ResourceName', ], 'description' => [ 'shape' => 'ResourceDescription', ], 'parentActionGroupSignature' => [ 'shape' => 'ActionGroupSignature', ], 'actionGroupExecutor' => [ 'shape' => 'ActionGroupExecutor', ], 'apiSchema' => [ 'shape' => 'APISchema', ], 'functionSchema' => [ 'shape' => 'FunctionSchema', ], 'parentActionGroupSignatureParams' => [ 'shape' => 'ActionGroupSignatureParams', ], ], ], 'AgentActionGroups' => [ 'type' => 'list', 'member' => [ 'shape' => 'AgentActionGroup', ], ], 'AgentAliasArn' => [ 'type' => 'string', 'max' => 2048, 'min' => 0, 'pattern' => 'arn:aws(-[^:]+)?:bedrock:[a-z0-9-]{1,20}:[0-9]{12}:agent-alias/[0-9a-zA-Z]{10}/[0-9a-zA-Z]{10}', ], 'AgentAliasId' => [ 'type' => 'string', 'max' => 10, 'min' => 0, 'pattern' => '[0-9a-zA-Z]+', ], 'AgentCollaboration' => [ 'type' => 'string', 'enum' => [ 'SUPERVISOR', 'SUPERVISOR_ROUTER', 'DISABLED', ], ], 'AgentCollaboratorInputPayload' => [ 'type' => 'structure', 'members' => [ 'type' => [ 'shape' => 'PayloadType', ], 'text' => [ 'shape' => 'AgentCollaboratorPayloadString', ], 'returnControlResults' => [ 'shape' => 'ReturnControlResults', ], ], ], 'AgentCollaboratorInvocationInput' => [ 'type' => 'structure', 'members' => [ 'agentCollaboratorName' => [ 'shape' => 'String', ], 'agentCollaboratorAliasArn' => [ 'shape' => 'AgentAliasArn', ], 'input' => [ 'shape' => 'AgentCollaboratorInputPayload', ], ], ], 'AgentCollaboratorInvocationOutput' => [ 'type' => 'structure', 'members' => [ 'agentCollaboratorName' => [ 'shape' => 'String', ], 'agentCollaboratorAliasArn' => [ 'shape' => 'AgentAliasArn', ], 'output' => [ 'shape' => 'AgentCollaboratorOutputPayload', ], 'metadata' => [ 'shape' => 'Metadata', ], ], ], 'AgentCollaboratorOutputPayload' => [ 'type' => 'structure', 'members' => [ 'type' => [ 'shape' => 'PayloadType', ], 'text' => [ 'shape' => 'AgentCollaboratorPayloadString', ], 'returnControlPayload' => [ 'shape' => 'ReturnControlPayload', ], ], ], 'AgentCollaboratorPayloadString' => [ 'type' => 'string', 'sensitive' => true, ], 'AgentId' => [ 'type' => 'string', 'max' => 10, 'min' => 0, 'pattern' => '[0-9a-zA-Z]+', ], 'AgentTraces' => [ 'type' => 'list', 'member' => [ 'shape' => 'TracePart', ], ], 'AgentVersion' => [ 'type' => 'string', 'max' => 5, 'min' => 1, 'pattern' => '(DRAFT|[0-9]{0,4}[1-9][0-9]{0,4})', ], 'AnalyzePromptEvent' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'event' => true, 'sensitive' => true, ], 'ApiContentMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'PropertyParameters', ], ], 'ApiInvocationInput' => [ 'type' => 'structure', 'required' => [ 'actionGroup', ], 'members' => [ 'actionGroup' => [ 'shape' => 'String', ], 'httpMethod' => [ 'shape' => 'String', ], 'apiPath' => [ 'shape' => 'ApiPath', ], 'parameters' => [ 'shape' => 'ApiParameters', ], 'requestBody' => [ 'shape' => 'ApiRequestBody', ], 'actionInvocationType' => [ 'shape' => 'ActionInvocationType', ], 'agentId' => [ 'shape' => 'String', ], 'collaboratorName' => [ 'shape' => 'Name', ], ], ], 'ApiParameter' => [ 'type' => 'structure', 'members' => [ 'name' => [ 'shape' => 'String', ], 'type' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'String', ], ], ], 'ApiParameters' => [ 'type' => 'list', 'member' => [ 'shape' => 'ApiParameter', ], ], 'ApiPath' => [ 'type' => 'string', 'sensitive' => true, ], 'ApiRequestBody' => [ 'type' => 'structure', 'members' => [ 'content' => [ 'shape' => 'ApiContentMap', ], ], ], 'ApiResult' => [ 'type' => 'structure', 'required' => [ 'actionGroup', ], 'members' => [ 'actionGroup' => [ 'shape' => 'String', ], 'httpMethod' => [ 'shape' => 'String', ], 'apiPath' => [ 'shape' => 'ApiPath', ], 'confirmationState' => [ 'shape' => 'ConfirmationState', ], 'responseState' => [ 'shape' => 'ResponseState', ], 'httpStatusCode' => [ 'shape' => 'Integer', ], 'responseBody' => [ 'shape' => 'ResponseBody', ], 'agentId' => [ 'shape' => 'String', ], ], ], 'AttributeType' => [ 'type' => 'string', 'enum' => [ 'STRING', 'NUMBER', 'BOOLEAN', 'STRING_LIST', ], ], 'Attribution' => [ 'type' => 'structure', 'members' => [ 'citations' => [ 'shape' => 'Citations', ], ], ], 'BadGatewayException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'NonBlankString', ], 'resourceName' => [ 'shape' => 'NonBlankString', ], ], 'error' => [ 'httpStatusCode' => 502, ], 'exception' => true, 'fault' => true, ], 'BasePromptTemplate' => [ 'type' => 'string', 'max' => 100000, 'min' => 1, 'sensitive' => true, ], 'BedrockModelArn' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, 'pattern' => '(arn:aws(-[^:]+)?:(bedrock|sagemaker):[a-z0-9-]{1,20}:([0-9]{12})?:([a-z-]+/)?)?([a-z0-9.-]{1,63}){0,2}(([:][a-z0-9-]{1,63}){0,2})?(/[a-z0-9]{1,12})?', ], 'BedrockModelConfigurations' => [ 'type' => 'structure', 'members' => [ 'performanceConfig' => [ 'shape' => 'PerformanceConfiguration', ], ], ], 'BedrockRerankingConfiguration' => [ 'type' => 'structure', 'required' => [ 'modelConfiguration', ], 'members' => [ 'numberOfResults' => [ 'shape' => 'BedrockRerankingConfigurationNumberOfResultsInteger', ], 'modelConfiguration' => [ 'shape' => 'BedrockRerankingModelConfiguration', ], ], ], 'BedrockRerankingConfigurationNumberOfResultsInteger' => [ 'type' => 'integer', 'box' => true, 'max' => 1000, 'min' => 1, ], 'BedrockRerankingModelArn' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, 'pattern' => '(arn:aws(-[^:]+)?:bedrock:[a-z0-9-]{1,20}::foundation-model/(.*))?', ], 'BedrockRerankingModelConfiguration' => [ 'type' => 'structure', 'required' => [ 'modelArn', ], 'members' => [ 'modelArn' => [ 'shape' => 'BedrockModelArn', ], 'additionalModelRequestFields' => [ 'shape' => 'AdditionalModelRequestFields', ], ], ], 'BedrockSessionContentBlock' => [ 'type' => 'structure', 'members' => [ 'text' => [ 'shape' => 'BedrockSessionContentBlockTextString', ], 'image' => [ 'shape' => 'ImageBlock', ], ], 'sensitive' => true, 'union' => true, ], 'BedrockSessionContentBlockTextString' => [ 'type' => 'string', 'min' => 1, ], 'BedrockSessionContentBlocks' => [ 'type' => 'list', 'member' => [ 'shape' => 'BedrockSessionContentBlock', ], 'min' => 1, ], 'Blob' => [ 'type' => 'blob', ], 'Boolean' => [ 'type' => 'boolean', 'box' => true, ], 'ByteContentBlob' => [ 'type' => 'blob', 'max' => 10485760, 'min' => 1, 'sensitive' => true, ], 'ByteContentDoc' => [ 'type' => 'structure', 'required' => [ 'identifier', 'contentType', 'data', ], 'members' => [ 'identifier' => [ 'shape' => 'Identifier', ], 'contentType' => [ 'shape' => 'ContentType', ], 'data' => [ 'shape' => 'ByteContentBlob', ], ], ], 'ByteContentFile' => [ 'type' => 'structure', 'required' => [ 'mediaType', 'data', ], 'members' => [ 'mediaType' => [ 'shape' => 'MimeType', ], 'data' => [ 'shape' => 'ByteContentBlob', ], ], ], 'Caller' => [ 'type' => 'structure', 'members' => [ 'agentAliasArn' => [ 'shape' => 'AgentAliasArn', ], ], 'union' => true, ], 'CallerChain' => [ 'type' => 'list', 'member' => [ 'shape' => 'Caller', ], ], 'Citation' => [ 'type' => 'structure', 'members' => [ 'generatedResponsePart' => [ 'shape' => 'GeneratedResponsePart', ], 'retrievedReferences' => [ 'shape' => 'RetrievedReferences', ], ], ], 'CitationEvent' => [ 'type' => 'structure', 'members' => [ 'citation' => [ 'shape' => 'Citation', 'deprecated' => true, 'deprecatedMessage' => 'Citation is deprecated. Please use GeneratedResponsePart and RetrievedReferences for citation event.', 'deprecatedSince' => '2024-12-17', ], 'generatedResponsePart' => [ 'shape' => 'GeneratedResponsePart', ], 'retrievedReferences' => [ 'shape' => 'RetrievedReferences', ], ], 'event' => true, ], 'Citations' => [ 'type' => 'list', 'member' => [ 'shape' => 'Citation', ], ], 'CodeInterpreterInvocationInput' => [ 'type' => 'structure', 'members' => [ 'code' => [ 'shape' => 'String', ], 'files' => [ 'shape' => 'Files', ], ], ], 'CodeInterpreterInvocationOutput' => [ 'type' => 'structure', 'members' => [ 'executionOutput' => [ 'shape' => 'String', ], 'executionError' => [ 'shape' => 'String', ], 'files' => [ 'shape' => 'Files', ], 'executionTimeout' => [ 'shape' => 'Boolean', ], 'metadata' => [ 'shape' => 'Metadata', ], ], ], 'CollaborationInstruction' => [ 'type' => 'string', 'max' => 4000, 'min' => 1, 'sensitive' => true, ], 'Collaborator' => [ 'type' => 'structure', 'required' => [ 'foundationModel', 'instruction', ], 'members' => [ 'customerEncryptionKeyArn' => [ 'shape' => 'KmsKeyArn', ], 'foundationModel' => [ 'shape' => 'ModelIdentifier', ], 'instruction' => [ 'shape' => 'Instruction', ], 'idleSessionTTLInSeconds' => [ 'shape' => 'SessionTTL', ], 'actionGroups' => [ 'shape' => 'AgentActionGroups', ], 'knowledgeBases' => [ 'shape' => 'KnowledgeBases', ], 'guardrailConfiguration' => [ 'shape' => 'GuardrailConfigurationWithArn', ], 'promptOverrideConfiguration' => [ 'shape' => 'PromptOverrideConfiguration', ], 'agentCollaboration' => [ 'shape' => 'AgentCollaboration', ], 'collaboratorConfigurations' => [ 'shape' => 'CollaboratorConfigurations', ], 'agentName' => [ 'shape' => 'Name', ], ], ], 'CollaboratorConfiguration' => [ 'type' => 'structure', 'required' => [ 'collaboratorName', 'collaboratorInstruction', ], 'members' => [ 'collaboratorName' => [ 'shape' => 'Name', ], 'collaboratorInstruction' => [ 'shape' => 'CollaborationInstruction', ], 'agentAliasArn' => [ 'shape' => 'AgentAliasArn', ], 'relayConversationHistory' => [ 'shape' => 'RelayConversationHistory', ], ], ], 'CollaboratorConfigurations' => [ 'type' => 'list', 'member' => [ 'shape' => 'CollaboratorConfiguration', ], ], 'Collaborators' => [ 'type' => 'list', 'member' => [ 'shape' => 'Collaborator', ], ], 'ConditionResultEvent' => [ 'type' => 'structure', 'required' => [ 'nodeName', 'timestamp', 'satisfiedConditions', ], 'members' => [ 'nodeName' => [ 'shape' => 'NodeName', ], 'timestamp' => [ 'shape' => 'DateTimestamp', ], 'satisfiedConditions' => [ 'shape' => 'SatisfiedConditions', ], ], 'sensitive' => true, ], 'ConfirmationState' => [ 'type' => 'string', 'enum' => [ 'CONFIRM', 'DENY', ], ], 'ConflictException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'NonBlankString', ], ], 'error' => [ 'httpStatusCode' => 409, 'senderFault' => true, ], 'exception' => true, ], 'ContentBlock' => [ 'type' => 'structure', 'members' => [ 'text' => [ 'shape' => 'String', ], ], 'sensitive' => true, 'union' => true, ], 'ContentBlocks' => [ 'type' => 'list', 'member' => [ 'shape' => 'ContentBlock', ], ], 'ContentBody' => [ 'type' => 'structure', 'members' => [ 'body' => [ 'shape' => 'String', ], 'images' => [ 'shape' => 'ImageInputs', ], ], ], 'ContentMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'Parameters', ], ], 'ContentType' => [ 'type' => 'string', 'pattern' => '.*[a-z]{1,20}/.{1,20}.*', ], 'ConversationHistory' => [ 'type' => 'structure', 'members' => [ 'messages' => [ 'shape' => 'Messages', ], ], ], 'ConversationRole' => [ 'type' => 'string', 'enum' => [ 'user', 'assistant', ], ], 'CreateInvocationRequest' => [ 'type' => 'structure', 'required' => [ 'sessionIdentifier', ], 'members' => [ 'invocationId' => [ 'shape' => 'Uuid', ], 'description' => [ 'shape' => 'InvocationDescription', ], 'sessionIdentifier' => [ 'shape' => 'SessionIdentifier', 'location' => 'uri', 'locationName' => 'sessionIdentifier', ], ], ], 'CreateInvocationResponse' => [ 'type' => 'structure', 'required' => [ 'sessionId', 'invocationId', 'createdAt', ], 'members' => [ 'sessionId' => [ 'shape' => 'Uuid', ], 'invocationId' => [ 'shape' => 'Uuid', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], ], ], 'CreateSessionRequest' => [ 'type' => 'structure', 'members' => [ 'sessionMetadata' => [ 'shape' => 'SessionMetadataMap', ], 'encryptionKeyArn' => [ 'shape' => 'KmsKeyArn', ], 'tags' => [ 'shape' => 'TagsMap', ], ], ], 'CreateSessionResponse' => [ 'type' => 'structure', 'required' => [ 'sessionId', 'sessionArn', 'sessionStatus', 'createdAt', ], 'members' => [ 'sessionId' => [ 'shape' => 'Uuid', ], 'sessionArn' => [ 'shape' => 'SessionArn', ], 'sessionStatus' => [ 'shape' => 'SessionStatus', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], ], ], 'CreationMode' => [ 'type' => 'string', 'enum' => [ 'DEFAULT', 'OVERRIDDEN', ], ], 'CustomControlMethod' => [ 'type' => 'string', 'enum' => [ 'RETURN_CONTROL', ], ], 'CustomOrchestration' => [ 'type' => 'structure', 'members' => [ 'executor' => [ 'shape' => 'OrchestrationExecutor', ], ], ], 'CustomOrchestrationTrace' => [ 'type' => 'structure', 'members' => [ 'traceId' => [ 'shape' => 'TraceId', ], 'event' => [ 'shape' => 'CustomOrchestrationTraceEvent', ], ], 'sensitive' => true, ], 'CustomOrchestrationTraceEvent' => [ 'type' => 'structure', 'members' => [ 'text' => [ 'shape' => 'String', ], ], 'sensitive' => true, ], 'DateTimestamp' => [ 'type' => 'timestamp', 'timestampFormat' => 'iso8601', ], 'DeleteAgentMemoryRequest' => [ 'type' => 'structure', 'required' => [ 'agentId', 'agentAliasId', ], 'members' => [ 'agentId' => [ 'shape' => 'AgentId', 'location' => 'uri', 'locationName' => 'agentId', ], 'agentAliasId' => [ 'shape' => 'AgentAliasId', 'location' => 'uri', 'locationName' => 'agentAliasId', ], 'memoryId' => [ 'shape' => 'MemoryId', 'location' => 'querystring', 'locationName' => 'memoryId', ], 'sessionId' => [ 'shape' => 'SessionId', 'location' => 'querystring', 'locationName' => 'sessionId', ], ], ], 'DeleteAgentMemoryResponse' => [ 'type' => 'structure', 'members' => [], ], 'DeleteSessionRequest' => [ 'type' => 'structure', 'required' => [ 'sessionIdentifier', ], 'members' => [ 'sessionIdentifier' => [ 'shape' => 'SessionIdentifier', 'location' => 'uri', 'locationName' => 'sessionIdentifier', ], ], ], 'DeleteSessionResponse' => [ 'type' => 'structure', 'members' => [], ], 'DependencyFailedException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'NonBlankString', ], 'resourceName' => [ 'shape' => 'NonBlankString', ], ], 'error' => [ 'httpStatusCode' => 424, 'senderFault' => true, ], 'exception' => true, ], 'Document' => [ 'type' => 'structure', 'members' => [], 'document' => true, ], 'Double' => [ 'type' => 'double', 'box' => true, ], 'EndSessionRequest' => [ 'type' => 'structure', 'required' => [ 'sessionIdentifier', ], 'members' => [ 'sessionIdentifier' => [ 'shape' => 'SessionIdentifier', 'location' => 'uri', 'locationName' => 'sessionIdentifier', ], ], ], 'EndSessionResponse' => [ 'type' => 'structure', 'required' => [ 'sessionId', 'sessionArn', 'sessionStatus', ], 'members' => [ 'sessionId' => [ 'shape' => 'Uuid', ], 'sessionArn' => [ 'shape' => 'SessionArn', ], 'sessionStatus' => [ 'shape' => 'SessionStatus', ], ], ], 'ExecutionType' => [ 'type' => 'string', 'enum' => [ 'LAMBDA', 'RETURN_CONTROL', ], ], 'ExternalSource' => [ 'type' => 'structure', 'required' => [ 'sourceType', ], 'members' => [ 'sourceType' => [ 'shape' => 'ExternalSourceType', ], 's3Location' => [ 'shape' => 'S3ObjectDoc', ], 'byteContent' => [ 'shape' => 'ByteContentDoc', ], ], ], 'ExternalSourceType' => [ 'type' => 'string', 'enum' => [ 'S3', 'BYTE_CONTENT', ], ], 'ExternalSources' => [ 'type' => 'list', 'member' => [ 'shape' => 'ExternalSource', ], 'max' => 1, 'min' => 1, ], 'ExternalSourcesGenerationConfiguration' => [ 'type' => 'structure', 'members' => [ 'promptTemplate' => [ 'shape' => 'PromptTemplate', ], 'guardrailConfiguration' => [ 'shape' => 'GuardrailConfiguration', ], 'inferenceConfig' => [ 'shape' => 'InferenceConfig', ], 'additionalModelRequestFields' => [ 'shape' => 'AdditionalModelRequestFields', ], 'performanceConfig' => [ 'shape' => 'PerformanceConfiguration', ], ], ], 'ExternalSourcesRetrieveAndGenerateConfiguration' => [ 'type' => 'structure', 'required' => [ 'modelArn', 'sources', ], 'members' => [ 'modelArn' => [ 'shape' => 'BedrockModelArn', ], 'sources' => [ 'shape' => 'ExternalSources', ], 'generationConfiguration' => [ 'shape' => 'ExternalSourcesGenerationConfiguration', ], ], ], 'FailureReasonString' => [ 'type' => 'string', 'sensitive' => true, ], 'FailureTrace' => [ 'type' => 'structure', 'members' => [ 'traceId' => [ 'shape' => 'TraceId', ], 'failureReason' => [ 'shape' => 'FailureReasonString', ], 'failureCode' => [ 'shape' => 'Integer', ], 'metadata' => [ 'shape' => 'Metadata', ], ], 'sensitive' => true, ], 'FieldForReranking' => [ 'type' => 'structure', 'required' => [ 'fieldName', ], 'members' => [ 'fieldName' => [ 'shape' => 'FieldForRerankingFieldNameString', ], ], ], 'FieldForRerankingFieldNameString' => [ 'type' => 'string', 'max' => 2000, 'min' => 1, ], 'FieldsForReranking' => [ 'type' => 'list', 'member' => [ 'shape' => 'FieldForReranking', ], 'max' => 100, 'min' => 1, 'sensitive' => true, ], 'FileBody' => [ 'type' => 'blob', 'max' => 1000000, 'min' => 0, 'sensitive' => true, ], 'FilePart' => [ 'type' => 'structure', 'members' => [ 'files' => [ 'shape' => 'OutputFiles', ], ], 'event' => true, ], 'FileSource' => [ 'type' => 'structure', 'required' => [ 'sourceType', ], 'members' => [ 'sourceType' => [ 'shape' => 'FileSourceType', ], 's3Location' => [ 'shape' => 'S3ObjectFile', ], 'byteContent' => [ 'shape' => 'ByteContentFile', ], ], ], 'FileSourceType' => [ 'type' => 'string', 'enum' => [ 'S3', 'BYTE_CONTENT', ], ], 'FileUseCase' => [ 'type' => 'string', 'enum' => [ 'CODE_INTERPRETER', 'CHAT', ], ], 'Files' => [ 'type' => 'list', 'member' => [ 'shape' => 'String', ], ], 'FilterAttribute' => [ 'type' => 'structure', 'required' => [ 'key', 'value', ], 'members' => [ 'key' => [ 'shape' => 'FilterKey', ], 'value' => [ 'shape' => 'FilterValue', ], ], ], 'FilterKey' => [ 'type' => 'string', 'max' => 100, 'min' => 1, ], 'FilterValue' => [ 'type' => 'structure', 'members' => [], 'document' => true, ], 'FinalResponse' => [ 'type' => 'structure', 'members' => [ 'text' => [ 'shape' => 'FinalResponseString', ], 'metadata' => [ 'shape' => 'Metadata', ], ], ], 'FinalResponseString' => [ 'type' => 'string', 'sensitive' => true, ], 'Float' => [ 'type' => 'float', 'box' => true, ], 'FlowAliasIdentifier' => [ 'type' => 'string', 'max' => 2048, 'min' => 0, 'pattern' => '(arn:aws:bedrock:[a-z0-9-]{1,20}:[0-9]{12}:flow/[0-9a-zA-Z]{10}/alias/[0-9a-zA-Z]{10})|(\\bTSTALIASID\\b|[0-9a-zA-Z]+)', ], 'FlowCompletionEvent' => [ 'type' => 'structure', 'required' => [ 'completionReason', ], 'members' => [ 'completionReason' => [ 'shape' => 'FlowCompletionReason', ], ], 'event' => true, 'sensitive' => true, ], 'FlowCompletionReason' => [ 'type' => 'string', 'enum' => [ 'SUCCESS', 'INPUT_REQUIRED', ], ], 'FlowControlNodeType' => [ 'type' => 'string', 'enum' => [ 'Iterator', 'Loop', ], ], 'FlowErrorCode' => [ 'type' => 'string', 'enum' => [ 'VALIDATION', 'INTERNAL_SERVER', 'NODE_EXECUTION_FAILED', ], ], 'FlowExecutionContent' => [ 'type' => 'structure', 'members' => [ 'document' => [ 'shape' => 'Document', ], ], 'sensitive' => true, 'union' => true, ], 'FlowExecutionError' => [ 'type' => 'structure', 'members' => [ 'nodeName' => [ 'shape' => 'NodeName', ], 'error' => [ 'shape' => 'FlowExecutionErrorType', ], 'message' => [ 'shape' => 'String', ], ], ], 'FlowExecutionErrorType' => [ 'type' => 'string', 'enum' => [ 'ExecutionTimedOut', ], ], 'FlowExecutionErrors' => [ 'type' => 'list', 'member' => [ 'shape' => 'FlowExecutionError', ], ], 'FlowExecutionEvent' => [ 'type' => 'structure', 'members' => [ 'flowInputEvent' => [ 'shape' => 'FlowExecutionInputEvent', ], 'flowOutputEvent' => [ 'shape' => 'FlowExecutionOutputEvent', ], 'nodeInputEvent' => [ 'shape' => 'NodeInputEvent', ], 'nodeOutputEvent' => [ 'shape' => 'NodeOutputEvent', ], 'conditionResultEvent' => [ 'shape' => 'ConditionResultEvent', ], 'nodeFailureEvent' => [ 'shape' => 'NodeFailureEvent', ], 'flowFailureEvent' => [ 'shape' => 'FlowFailureEvent', ], 'nodeActionEvent' => [ 'shape' => 'NodeActionEvent', ], 'nodeDependencyEvent' => [ 'shape' => 'NodeDependencyEvent', ], ], 'union' => true, ], 'FlowExecutionEventType' => [ 'type' => 'string', 'enum' => [ 'Node', 'Flow', ], ], 'FlowExecutionEvents' => [ 'type' => 'list', 'member' => [ 'shape' => 'FlowExecutionEvent', ], 'max' => 10, 'min' => 0, ], 'FlowExecutionId' => [ 'type' => 'string', 'max' => 100, 'min' => 2, 'pattern' => '[0-9a-zA-Z._:-]+', ], 'FlowExecutionIdentifier' => [ 'type' => 'string', 'max' => 2048, 'min' => 0, 'pattern' => '[a-zA-Z0-9-]{1,36}$|^(arn:aws:bedrock:[a-z0-9-]{1,20}:[0-9]{12}:flow/[0-9a-zA-Z]{10}/alias/[0-9a-zA-Z]{10}/execution/[a-zA-Z0-9-]{1,36})', ], 'FlowExecutionInputEvent' => [ 'type' => 'structure', 'required' => [ 'nodeName', 'timestamp', 'fields', ], 'members' => [ 'nodeName' => [ 'shape' => 'NodeName', ], 'timestamp' => [ 'shape' => 'DateTimestamp', ], 'fields' => [ 'shape' => 'FlowInputFields', ], ], 'sensitive' => true, ], 'FlowExecutionName' => [ 'type' => 'string', 'max' => 36, 'min' => 0, 'pattern' => '[a-zA-Z0-9-]{1,36}', ], 'FlowExecutionOutputEvent' => [ 'type' => 'structure', 'required' => [ 'nodeName', 'timestamp', 'fields', ], 'members' => [ 'nodeName' => [ 'shape' => 'NodeName', ], 'timestamp' => [ 'shape' => 'DateTimestamp', ], 'fields' => [ 'shape' => 'FlowOutputFields', ], ], 'sensitive' => true, ], 'FlowExecutionRoleArn' => [ 'type' => 'string', 'max' => 2048, 'min' => 0, 'pattern' => 'arn:aws(-[^:]+)?:iam::([0-9]{12})?:role/(service-role/)?.+', ], 'FlowExecutionStatus' => [ 'type' => 'string', 'enum' => [ 'Running', 'Succeeded', 'Failed', 'TimedOut', 'Aborted', ], ], 'FlowExecutionSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'FlowExecutionSummary', ], 'max' => 10, 'min' => 0, ], 'FlowExecutionSummary' => [ 'type' => 'structure', 'required' => [ 'executionArn', 'flowAliasIdentifier', 'flowIdentifier', 'flowVersion', 'status', 'createdAt', ], 'members' => [ 'executionArn' => [ 'shape' => 'FlowExecutionIdentifier', ], 'flowAliasIdentifier' => [ 'shape' => 'FlowAliasIdentifier', ], 'flowIdentifier' => [ 'shape' => 'FlowIdentifier', ], 'flowVersion' => [ 'shape' => 'Version', ], 'status' => [ 'shape' => 'FlowExecutionStatus', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], 'endedAt' => [ 'shape' => 'DateTimestamp', ], ], ], 'FlowFailureEvent' => [ 'type' => 'structure', 'required' => [ 'timestamp', 'errorCode', 'errorMessage', ], 'members' => [ 'timestamp' => [ 'shape' => 'DateTimestamp', ], 'errorCode' => [ 'shape' => 'FlowErrorCode', ], 'errorMessage' => [ 'shape' => 'String', ], ], 'sensitive' => true, ], 'FlowIdentifier' => [ 'type' => 'string', 'max' => 2048, 'min' => 0, 'pattern' => '(arn:aws:bedrock:[a-z0-9-]{1,20}:[0-9]{12}:flow/[0-9a-zA-Z]{10})|([0-9a-zA-Z]{10})', ], 'FlowInput' => [ 'type' => 'structure', 'required' => [ 'nodeName', 'content', ], 'members' => [ 'nodeName' => [ 'shape' => 'NodeName', ], 'nodeOutputName' => [ 'shape' => 'NodeOutputName', ], 'content' => [ 'shape' => 'FlowInputContent', ], 'nodeInputName' => [ 'shape' => 'NodeInputName', ], ], ], 'FlowInputContent' => [ 'type' => 'structure', 'members' => [ 'document' => [ 'shape' => 'Document', ], ], 'sensitive' => true, 'union' => true, ], 'FlowInputField' => [ 'type' => 'structure', 'required' => [ 'name', 'content', ], 'members' => [ 'name' => [ 'shape' => 'NodeInputName', ], 'content' => [ 'shape' => 'FlowExecutionContent', ], ], 'sensitive' => true, ], 'FlowInputFields' => [ 'type' => 'list', 'member' => [ 'shape' => 'FlowInputField', ], 'max' => 5, 'min' => 1, ], 'FlowInputs' => [ 'type' => 'list', 'member' => [ 'shape' => 'FlowInput', ], 'max' => 1, 'min' => 1, ], 'FlowMultiTurnInputContent' => [ 'type' => 'structure', 'members' => [ 'document' => [ 'shape' => 'Document', ], ], 'union' => true, ], 'FlowMultiTurnInputRequestEvent' => [ 'type' => 'structure', 'required' => [ 'nodeName', 'nodeType', 'content', ], 'members' => [ 'nodeName' => [ 'shape' => 'NodeName', ], 'nodeType' => [ 'shape' => 'NodeType', ], 'content' => [ 'shape' => 'FlowMultiTurnInputContent', ], ], 'event' => true, 'sensitive' => true, ], 'FlowNodeIODataType' => [ 'type' => 'string', 'enum' => [ 'String', 'Number', 'Boolean', 'Object', 'Array', ], ], 'FlowNodeInputCategory' => [ 'type' => 'string', 'enum' => [ 'LoopCondition', 'ReturnValueToLoopStart', 'ExitLoop', ], ], 'FlowNodeInputExpression' => [ 'type' => 'string', 'max' => 64, 'min' => 1, 'sensitive' => true, ], 'FlowNodeInputName' => [ 'type' => 'string', 'pattern' => '[a-zA-Z]([_]?[0-9a-zA-Z]){1,50}', ], 'FlowNodeOutputName' => [ 'type' => 'string', 'pattern' => '[a-zA-Z]([_]?[0-9a-zA-Z]){1,50}', ], 'FlowOutputContent' => [ 'type' => 'structure', 'members' => [ 'document' => [ 'shape' => 'Document', ], ], 'union' => true, ], 'FlowOutputEvent' => [ 'type' => 'structure', 'required' => [ 'nodeName', 'nodeType', 'content', ], 'members' => [ 'nodeName' => [ 'shape' => 'NodeName', ], 'nodeType' => [ 'shape' => 'NodeType', ], 'content' => [ 'shape' => 'FlowOutputContent', ], ], 'event' => true, 'sensitive' => true, ], 'FlowOutputField' => [ 'type' => 'structure', 'required' => [ 'name', 'content', ], 'members' => [ 'name' => [ 'shape' => 'NodeOutputName', ], 'content' => [ 'shape' => 'FlowExecutionContent', ], ], 'sensitive' => true, ], 'FlowOutputFields' => [ 'type' => 'list', 'member' => [ 'shape' => 'FlowOutputField', ], 'max' => 5, 'min' => 1, ], 'FlowResponseStream' => [ 'type' => 'structure', 'members' => [ 'flowOutputEvent' => [ 'shape' => 'FlowOutputEvent', ], 'flowCompletionEvent' => [ 'shape' => 'FlowCompletionEvent', ], 'flowTraceEvent' => [ 'shape' => 'FlowTraceEvent', ], 'internalServerException' => [ 'shape' => 'InternalServerException', ], 'validationException' => [ 'shape' => 'ValidationException', ], 'resourceNotFoundException' => [ 'shape' => 'ResourceNotFoundException', ], 'serviceQuotaExceededException' => [ 'shape' => 'ServiceQuotaExceededException', ], 'throttlingException' => [ 'shape' => 'ThrottlingException', ], 'accessDeniedException' => [ 'shape' => 'AccessDeniedException', ], 'conflictException' => [ 'shape' => 'ConflictException', ], 'dependencyFailedException' => [ 'shape' => 'DependencyFailedException', ], 'badGatewayException' => [ 'shape' => 'BadGatewayException', ], 'flowMultiTurnInputRequestEvent' => [ 'shape' => 'FlowMultiTurnInputRequestEvent', ], ], 'eventstream' => true, ], 'FlowTrace' => [ 'type' => 'structure', 'members' => [ 'nodeInputTrace' => [ 'shape' => 'FlowTraceNodeInputEvent', ], 'nodeOutputTrace' => [ 'shape' => 'FlowTraceNodeOutputEvent', ], 'conditionNodeResultTrace' => [ 'shape' => 'FlowTraceConditionNodeResultEvent', ], 'nodeActionTrace' => [ 'shape' => 'FlowTraceNodeActionEvent', ], 'nodeDependencyTrace' => [ 'shape' => 'FlowTraceDependencyEvent', ], ], 'sensitive' => true, 'union' => true, ], 'FlowTraceCondition' => [ 'type' => 'structure', 'required' => [ 'conditionName', ], 'members' => [ 'conditionName' => [ 'shape' => 'String', ], ], 'sensitive' => true, ], 'FlowTraceConditionNodeResultEvent' => [ 'type' => 'structure', 'required' => [ 'nodeName', 'timestamp', 'satisfiedConditions', ], 'members' => [ 'nodeName' => [ 'shape' => 'NodeName', ], 'timestamp' => [ 'shape' => 'DateTimestamp', ], 'satisfiedConditions' => [ 'shape' => 'FlowTraceConditions', ], ], 'sensitive' => true, ], 'FlowTraceConditions' => [ 'type' => 'list', 'member' => [ 'shape' => 'FlowTraceCondition', ], 'max' => 5, 'min' => 1, ], 'FlowTraceDependencyEvent' => [ 'type' => 'structure', 'required' => [ 'nodeName', 'timestamp', 'traceElements', ], 'members' => [ 'nodeName' => [ 'shape' => 'NodeName', ], 'timestamp' => [ 'shape' => 'DateTimestamp', ], 'traceElements' => [ 'shape' => 'TraceElements', ], ], 'sensitive' => true, ], 'FlowTraceEvent' => [ 'type' => 'structure', 'required' => [ 'trace', ], 'members' => [ 'trace' => [ 'shape' => 'FlowTrace', ], ], 'event' => true, ], 'FlowTraceNodeActionEvent' => [ 'type' => 'structure', 'required' => [ 'nodeName', 'timestamp', 'requestId', 'serviceName', 'operationName', ], 'members' => [ 'nodeName' => [ 'shape' => 'NodeName', ], 'timestamp' => [ 'shape' => 'DateTimestamp', ], 'requestId' => [ 'shape' => 'String', ], 'serviceName' => [ 'shape' => 'String', ], 'operationName' => [ 'shape' => 'String', ], 'operationRequest' => [ 'shape' => 'Document', ], 'operationResponse' => [ 'shape' => 'Document', ], ], 'sensitive' => true, ], 'FlowTraceNodeInputContent' => [ 'type' => 'structure', 'members' => [ 'document' => [ 'shape' => 'Document', ], ], 'sensitive' => true, 'union' => true, ], 'FlowTraceNodeInputEvent' => [ 'type' => 'structure', 'required' => [ 'nodeName', 'timestamp', 'fields', ], 'members' => [ 'nodeName' => [ 'shape' => 'NodeName', ], 'timestamp' => [ 'shape' => 'DateTimestamp', ], 'fields' => [ 'shape' => 'FlowTraceNodeInputFields', ], ], 'sensitive' => true, ], 'FlowTraceNodeInputExecutionChain' => [ 'type' => 'list', 'member' => [ 'shape' => 'FlowTraceNodeInputExecutionChainItem', ], 'sensitive' => true, ], 'FlowTraceNodeInputExecutionChainItem' => [ 'type' => 'structure', 'required' => [ 'nodeName', 'type', ], 'members' => [ 'nodeName' => [ 'shape' => 'NodeName', ], 'index' => [ 'shape' => 'Integer', ], 'type' => [ 'shape' => 'FlowControlNodeType', ], ], 'sensitive' => true, ], 'FlowTraceNodeInputField' => [ 'type' => 'structure', 'required' => [ 'nodeInputName', 'content', ], 'members' => [ 'nodeInputName' => [ 'shape' => 'NodeInputName', ], 'content' => [ 'shape' => 'FlowTraceNodeInputContent', ], 'source' => [ 'shape' => 'FlowTraceNodeInputSource', ], 'type' => [ 'shape' => 'FlowNodeIODataType', ], 'category' => [ 'shape' => 'FlowNodeInputCategory', ], 'executionChain' => [ 'shape' => 'FlowTraceNodeInputExecutionChain', ], ], 'sensitive' => true, ], 'FlowTraceNodeInputFields' => [ 'type' => 'list', 'member' => [ 'shape' => 'FlowTraceNodeInputField', ], 'max' => 5, 'min' => 1, ], 'FlowTraceNodeInputSource' => [ 'type' => 'structure', 'required' => [ 'nodeName', 'outputFieldName', 'expression', ], 'members' => [ 'nodeName' => [ 'shape' => 'NodeName', ], 'outputFieldName' => [ 'shape' => 'FlowNodeOutputName', ], 'expression' => [ 'shape' => 'FlowNodeInputExpression', ], ], 'sensitive' => true, ], 'FlowTraceNodeOutputContent' => [ 'type' => 'structure', 'members' => [ 'document' => [ 'shape' => 'Document', ], ], 'union' => true, ], 'FlowTraceNodeOutputEvent' => [ 'type' => 'structure', 'required' => [ 'nodeName', 'timestamp', 'fields', ], 'members' => [ 'nodeName' => [ 'shape' => 'NodeName', ], 'timestamp' => [ 'shape' => 'DateTimestamp', ], 'fields' => [ 'shape' => 'FlowTraceNodeOutputFields', ], ], 'sensitive' => true, ], 'FlowTraceNodeOutputField' => [ 'type' => 'structure', 'required' => [ 'nodeOutputName', 'content', ], 'members' => [ 'nodeOutputName' => [ 'shape' => 'NodeOutputName', ], 'content' => [ 'shape' => 'FlowTraceNodeOutputContent', ], 'next' => [ 'shape' => 'FlowTraceNodeOutputNextList', ], 'type' => [ 'shape' => 'FlowNodeIODataType', ], ], 'sensitive' => true, ], 'FlowTraceNodeOutputFields' => [ 'type' => 'list', 'member' => [ 'shape' => 'FlowTraceNodeOutputField', ], 'max' => 2, 'min' => 1, ], 'FlowTraceNodeOutputNext' => [ 'type' => 'structure', 'required' => [ 'nodeName', 'inputFieldName', ], 'members' => [ 'nodeName' => [ 'shape' => 'NodeName', ], 'inputFieldName' => [ 'shape' => 'FlowNodeInputName', ], ], 'sensitive' => true, ], 'FlowTraceNodeOutputNextList' => [ 'type' => 'list', 'member' => [ 'shape' => 'FlowTraceNodeOutputNext', ], ], 'Function' => [ 'type' => 'string', 'sensitive' => true, ], 'FunctionDefinition' => [ 'type' => 'structure', 'required' => [ 'name', ], 'members' => [ 'name' => [ 'shape' => 'ResourceName', ], 'description' => [ 'shape' => 'FunctionDescription', ], 'parameters' => [ 'shape' => 'ParameterMap', ], 'requireConfirmation' => [ 'shape' => 'RequireConfirmation', ], ], ], 'FunctionDescription' => [ 'type' => 'string', 'max' => 1200, 'min' => 1, ], 'FunctionInvocationInput' => [ 'type' => 'structure', 'required' => [ 'actionGroup', ], 'members' => [ 'actionGroup' => [ 'shape' => 'String', ], 'parameters' => [ 'shape' => 'FunctionParameters', ], 'function' => [ 'shape' => 'String', ], 'actionInvocationType' => [ 'shape' => 'ActionInvocationType', ], 'agentId' => [ 'shape' => 'String', ], 'collaboratorName' => [ 'shape' => 'Name', ], ], ], 'FunctionParameter' => [ 'type' => 'structure', 'members' => [ 'name' => [ 'shape' => 'String', ], 'type' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'String', ], ], ], 'FunctionParameters' => [ 'type' => 'list', 'member' => [ 'shape' => 'FunctionParameter', ], ], 'FunctionResult' => [ 'type' => 'structure', 'required' => [ 'actionGroup', ], 'members' => [ 'actionGroup' => [ 'shape' => 'String', ], 'confirmationState' => [ 'shape' => 'ConfirmationState', ], 'function' => [ 'shape' => 'String', ], 'responseBody' => [ 'shape' => 'ResponseBody', ], 'responseState' => [ 'shape' => 'ResponseState', ], 'agentId' => [ 'shape' => 'String', ], ], ], 'FunctionSchema' => [ 'type' => 'structure', 'members' => [ 'functions' => [ 'shape' => 'Functions', ], ], 'union' => true, ], 'Functions' => [ 'type' => 'list', 'member' => [ 'shape' => 'FunctionDefinition', ], ], 'GenerateQueryRequest' => [ 'type' => 'structure', 'required' => [ 'queryGenerationInput', 'transformationConfiguration', ], 'members' => [ 'queryGenerationInput' => [ 'shape' => 'QueryGenerationInput', ], 'transformationConfiguration' => [ 'shape' => 'TransformationConfiguration', ], ], ], 'GenerateQueryResponse' => [ 'type' => 'structure', 'members' => [ 'queries' => [ 'shape' => 'GeneratedQueries', ], ], ], 'GeneratedQueries' => [ 'type' => 'list', 'member' => [ 'shape' => 'GeneratedQuery', ], 'min' => 0, ], 'GeneratedQuery' => [ 'type' => 'structure', 'members' => [ 'type' => [ 'shape' => 'GeneratedQueryType', ], 'sql' => [ 'shape' => 'String', ], ], 'sensitive' => true, ], 'GeneratedQueryType' => [ 'type' => 'string', 'enum' => [ 'REDSHIFT_SQL', ], ], 'GeneratedResponsePart' => [ 'type' => 'structure', 'members' => [ 'textResponsePart' => [ 'shape' => 'TextResponsePart', ], ], ], 'GenerationConfiguration' => [ 'type' => 'structure', 'members' => [ 'promptTemplate' => [ 'shape' => 'PromptTemplate', ], 'guardrailConfiguration' => [ 'shape' => 'GuardrailConfiguration', ], 'inferenceConfig' => [ 'shape' => 'InferenceConfig', ], 'additionalModelRequestFields' => [ 'shape' => 'AdditionalModelRequestFields', ], 'performanceConfig' => [ 'shape' => 'PerformanceConfiguration', ], ], ], 'GetAgentMemoryRequest' => [ 'type' => 'structure', 'required' => [ 'agentId', 'agentAliasId', 'memoryType', 'memoryId', ], 'members' => [ 'nextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'maxItems' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxItems', ], 'agentId' => [ 'shape' => 'AgentId', 'location' => 'uri', 'locationName' => 'agentId', ], 'agentAliasId' => [ 'shape' => 'AgentAliasId', 'location' => 'uri', 'locationName' => 'agentAliasId', ], 'memoryType' => [ 'shape' => 'MemoryType', 'location' => 'querystring', 'locationName' => 'memoryType', ], 'memoryId' => [ 'shape' => 'MemoryId', 'location' => 'querystring', 'locationName' => 'memoryId', ], ], ], 'GetAgentMemoryResponse' => [ 'type' => 'structure', 'members' => [ 'nextToken' => [ 'shape' => 'NextToken', ], 'memoryContents' => [ 'shape' => 'Memories', ], ], ], 'GetExecutionFlowSnapshotRequest' => [ 'type' => 'structure', 'required' => [ 'flowIdentifier', 'flowAliasIdentifier', 'executionIdentifier', ], 'members' => [ 'flowIdentifier' => [ 'shape' => 'FlowIdentifier', 'location' => 'uri', 'locationName' => 'flowIdentifier', ], 'flowAliasIdentifier' => [ 'shape' => 'FlowAliasIdentifier', 'location' => 'uri', 'locationName' => 'flowAliasIdentifier', ], 'executionIdentifier' => [ 'shape' => 'FlowExecutionIdentifier', 'location' => 'uri', 'locationName' => 'executionIdentifier', ], ], ], 'GetExecutionFlowSnapshotResponse' => [ 'type' => 'structure', 'required' => [ 'flowIdentifier', 'flowAliasIdentifier', 'flowVersion', 'executionRoleArn', 'definition', ], 'members' => [ 'flowIdentifier' => [ 'shape' => 'FlowIdentifier', ], 'flowAliasIdentifier' => [ 'shape' => 'FlowAliasIdentifier', ], 'flowVersion' => [ 'shape' => 'Version', ], 'executionRoleArn' => [ 'shape' => 'FlowExecutionRoleArn', ], 'definition' => [ 'shape' => 'String', ], 'customerEncryptionKeyArn' => [ 'shape' => 'KmsKeyArn', ], ], ], 'GetFlowExecutionRequest' => [ 'type' => 'structure', 'required' => [ 'flowIdentifier', 'flowAliasIdentifier', 'executionIdentifier', ], 'members' => [ 'flowIdentifier' => [ 'shape' => 'FlowIdentifier', 'location' => 'uri', 'locationName' => 'flowIdentifier', ], 'flowAliasIdentifier' => [ 'shape' => 'FlowAliasIdentifier', 'location' => 'uri', 'locationName' => 'flowAliasIdentifier', ], 'executionIdentifier' => [ 'shape' => 'FlowExecutionIdentifier', 'location' => 'uri', 'locationName' => 'executionIdentifier', ], ], ], 'GetFlowExecutionResponse' => [ 'type' => 'structure', 'required' => [ 'executionArn', 'status', 'startedAt', 'flowAliasIdentifier', 'flowIdentifier', 'flowVersion', ], 'members' => [ 'executionArn' => [ 'shape' => 'FlowExecutionIdentifier', ], 'status' => [ 'shape' => 'FlowExecutionStatus', ], 'startedAt' => [ 'shape' => 'DateTimestamp', ], 'endedAt' => [ 'shape' => 'DateTimestamp', ], 'errors' => [ 'shape' => 'FlowExecutionErrors', ], 'flowAliasIdentifier' => [ 'shape' => 'FlowAliasIdentifier', ], 'flowIdentifier' => [ 'shape' => 'FlowIdentifier', ], 'flowVersion' => [ 'shape' => 'Version', ], ], ], 'GetInvocationStepRequest' => [ 'type' => 'structure', 'required' => [ 'invocationIdentifier', 'invocationStepId', 'sessionIdentifier', ], 'members' => [ 'invocationIdentifier' => [ 'shape' => 'InvocationIdentifier', ], 'invocationStepId' => [ 'shape' => 'Uuid', 'location' => 'uri', 'locationName' => 'invocationStepId', ], 'sessionIdentifier' => [ 'shape' => 'SessionIdentifier', 'location' => 'uri', 'locationName' => 'sessionIdentifier', ], ], ], 'GetInvocationStepResponse' => [ 'type' => 'structure', 'required' => [ 'invocationStep', ], 'members' => [ 'invocationStep' => [ 'shape' => 'InvocationStep', ], ], ], 'GetSessionRequest' => [ 'type' => 'structure', 'required' => [ 'sessionIdentifier', ], 'members' => [ 'sessionIdentifier' => [ 'shape' => 'SessionIdentifier', 'location' => 'uri', 'locationName' => 'sessionIdentifier', ], ], ], 'GetSessionResponse' => [ 'type' => 'structure', 'required' => [ 'sessionId', 'sessionArn', 'sessionStatus', 'createdAt', 'lastUpdatedAt', ], 'members' => [ 'sessionId' => [ 'shape' => 'Uuid', ], 'sessionArn' => [ 'shape' => 'SessionArn', ], 'sessionStatus' => [ 'shape' => 'SessionStatus', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], 'lastUpdatedAt' => [ 'shape' => 'DateTimestamp', ], 'sessionMetadata' => [ 'shape' => 'SessionMetadataMap', ], 'encryptionKeyArn' => [ 'shape' => 'KmsKeyArn', ], ], ], 'GuadrailAction' => [ 'type' => 'string', 'enum' => [ 'INTERVENED', 'NONE', ], ], 'GuardrailAction' => [ 'type' => 'string', 'enum' => [ 'INTERVENED', 'NONE', ], ], 'GuardrailAssessment' => [ 'type' => 'structure', 'members' => [ 'topicPolicy' => [ 'shape' => 'GuardrailTopicPolicyAssessment', ], 'contentPolicy' => [ 'shape' => 'GuardrailContentPolicyAssessment', ], 'wordPolicy' => [ 'shape' => 'GuardrailWordPolicyAssessment', ], 'sensitiveInformationPolicy' => [ 'shape' => 'GuardrailSensitiveInformationPolicyAssessment', ], ], 'sensitive' => true, ], 'GuardrailAssessmentList' => [ 'type' => 'list', 'member' => [ 'shape' => 'GuardrailAssessment', ], ], 'GuardrailConfiguration' => [ 'type' => 'structure', 'required' => [ 'guardrailId', 'guardrailVersion', ], 'members' => [ 'guardrailId' => [ 'shape' => 'GuardrailConfigurationGuardrailIdString', ], 'guardrailVersion' => [ 'shape' => 'GuardrailConfigurationGuardrailVersionString', ], ], ], 'GuardrailConfigurationGuardrailIdString' => [ 'type' => 'string', 'max' => 64, 'min' => 0, 'pattern' => '[a-z0-9]+', ], 'GuardrailConfigurationGuardrailVersionString' => [ 'type' => 'string', 'max' => 5, 'min' => 1, 'pattern' => '(([1-9][0-9]{0,7})|(DRAFT))', ], 'GuardrailConfigurationWithArn' => [ 'type' => 'structure', 'required' => [ 'guardrailIdentifier', 'guardrailVersion', ], 'members' => [ 'guardrailIdentifier' => [ 'shape' => 'GuardrailIdentifierWithArn', ], 'guardrailVersion' => [ 'shape' => 'GuardrailVersion', ], ], ], 'GuardrailContentFilter' => [ 'type' => 'structure', 'members' => [ 'type' => [ 'shape' => 'GuardrailContentFilterType', ], 'confidence' => [ 'shape' => 'GuardrailContentFilterConfidence', ], 'action' => [ 'shape' => 'GuardrailContentPolicyAction', ], ], 'sensitive' => true, ], 'GuardrailContentFilterConfidence' => [ 'type' => 'string', 'enum' => [ 'NONE', 'LOW', 'MEDIUM', 'HIGH', ], ], 'GuardrailContentFilterList' => [ 'type' => 'list', 'member' => [ 'shape' => 'GuardrailContentFilter', ], 'sensitive' => true, ], 'GuardrailContentFilterType' => [ 'type' => 'string', 'enum' => [ 'INSULTS', 'HATE', 'SEXUAL', 'VIOLENCE', 'MISCONDUCT', 'PROMPT_ATTACK', ], ], 'GuardrailContentPolicyAction' => [ 'type' => 'string', 'enum' => [ 'BLOCKED', ], ], 'GuardrailContentPolicyAssessment' => [ 'type' => 'structure', 'members' => [ 'filters' => [ 'shape' => 'GuardrailContentFilterList', ], ], 'sensitive' => true, ], 'GuardrailCustomWord' => [ 'type' => 'structure', 'members' => [ 'match' => [ 'shape' => 'String', ], 'action' => [ 'shape' => 'GuardrailWordPolicyAction', ], ], 'sensitive' => true, ], 'GuardrailCustomWordList' => [ 'type' => 'list', 'member' => [ 'shape' => 'GuardrailCustomWord', ], 'sensitive' => true, ], 'GuardrailEvent' => [ 'type' => 'structure', 'members' => [ 'action' => [ 'shape' => 'GuadrailAction', ], ], 'event' => true, ], 'GuardrailIdentifierWithArn' => [ 'type' => 'string', 'max' => 2048, 'min' => 0, 'pattern' => '(([a-z0-9]+)|(arn:aws(-[^:]+)?:bedrock:[a-z0-9-]{1,20}:[0-9]{12}:guardrail/[a-z0-9]+))', ], 'GuardrailManagedWord' => [ 'type' => 'structure', 'members' => [ 'match' => [ 'shape' => 'String', ], 'type' => [ 'shape' => 'GuardrailManagedWordType', ], 'action' => [ 'shape' => 'GuardrailWordPolicyAction', ], ], 'sensitive' => true, ], 'GuardrailManagedWordList' => [ 'type' => 'list', 'member' => [ 'shape' => 'GuardrailManagedWord', ], 'sensitive' => true, ], 'GuardrailManagedWordType' => [ 'type' => 'string', 'enum' => [ 'PROFANITY', ], ], 'GuardrailPiiEntityFilter' => [ 'type' => 'structure', 'members' => [ 'type' => [ 'shape' => 'GuardrailPiiEntityType', ], 'match' => [ 'shape' => 'String', ], 'action' => [ 'shape' => 'GuardrailSensitiveInformationPolicyAction', ], ], 'sensitive' => true, ], 'GuardrailPiiEntityFilterList' => [ 'type' => 'list', 'member' => [ 'shape' => 'GuardrailPiiEntityFilter', ], 'sensitive' => true, ], 'GuardrailPiiEntityType' => [ 'type' => 'string', 'enum' => [ 'ADDRESS', 'AGE', 'AWS_ACCESS_KEY', 'AWS_SECRET_KEY', 'CA_HEALTH_NUMBER', 'CA_SOCIAL_INSURANCE_NUMBER', 'CREDIT_DEBIT_CARD_CVV', 'CREDIT_DEBIT_CARD_EXPIRY', 'CREDIT_DEBIT_CARD_NUMBER', 'DRIVER_ID', 'EMAIL', 'INTERNATIONAL_BANK_ACCOUNT_NUMBER', 'IP_ADDRESS', 'LICENSE_PLATE', 'MAC_ADDRESS', 'NAME', 'PASSWORD', 'PHONE', 'PIN', 'SWIFT_CODE', 'UK_NATIONAL_HEALTH_SERVICE_NUMBER', 'UK_NATIONAL_INSURANCE_NUMBER', 'UK_UNIQUE_TAXPAYER_REFERENCE_NUMBER', 'URL', 'USERNAME', 'US_BANK_ACCOUNT_NUMBER', 'US_BANK_ROUTING_NUMBER', 'US_INDIVIDUAL_TAX_IDENTIFICATION_NUMBER', 'US_PASSPORT_NUMBER', 'US_SOCIAL_SECURITY_NUMBER', 'VEHICLE_IDENTIFICATION_NUMBER', ], ], 'GuardrailRegexFilter' => [ 'type' => 'structure', 'members' => [ 'name' => [ 'shape' => 'String', ], 'regex' => [ 'shape' => 'String', ], 'match' => [ 'shape' => 'String', ], 'action' => [ 'shape' => 'GuardrailSensitiveInformationPolicyAction', ], ], 'sensitive' => true, ], 'GuardrailRegexFilterList' => [ 'type' => 'list', 'member' => [ 'shape' => 'GuardrailRegexFilter', ], 'sensitive' => true, ], 'GuardrailSensitiveInformationPolicyAction' => [ 'type' => 'string', 'enum' => [ 'BLOCKED', 'ANONYMIZED', ], ], 'GuardrailSensitiveInformationPolicyAssessment' => [ 'type' => 'structure', 'members' => [ 'piiEntities' => [ 'shape' => 'GuardrailPiiEntityFilterList', ], 'regexes' => [ 'shape' => 'GuardrailRegexFilterList', ], ], 'sensitive' => true, ], 'GuardrailTopic' => [ 'type' => 'structure', 'members' => [ 'name' => [ 'shape' => 'String', ], 'type' => [ 'shape' => 'GuardrailTopicType', ], 'action' => [ 'shape' => 'GuardrailTopicPolicyAction', ], ], 'sensitive' => true, ], 'GuardrailTopicList' => [ 'type' => 'list', 'member' => [ 'shape' => 'GuardrailTopic', ], 'sensitive' => true, ], 'GuardrailTopicPolicyAction' => [ 'type' => 'string', 'enum' => [ 'BLOCKED', ], ], 'GuardrailTopicPolicyAssessment' => [ 'type' => 'structure', 'members' => [ 'topics' => [ 'shape' => 'GuardrailTopicList', ], ], 'sensitive' => true, ], 'GuardrailTopicType' => [ 'type' => 'string', 'enum' => [ 'DENY', ], ], 'GuardrailTrace' => [ 'type' => 'structure', 'members' => [ 'action' => [ 'shape' => 'GuardrailAction', ], 'traceId' => [ 'shape' => 'TraceId', ], 'inputAssessments' => [ 'shape' => 'GuardrailAssessmentList', ], 'outputAssessments' => [ 'shape' => 'GuardrailAssessmentList', ], 'metadata' => [ 'shape' => 'Metadata', ], ], 'sensitive' => true, ], 'GuardrailVersion' => [ 'type' => 'string', 'max' => 5, 'min' => 1, 'pattern' => '(([1-9][0-9]{0,7})|(DRAFT))', ], 'GuardrailWordPolicyAction' => [ 'type' => 'string', 'enum' => [ 'BLOCKED', ], ], 'GuardrailWordPolicyAssessment' => [ 'type' => 'structure', 'members' => [ 'customWords' => [ 'shape' => 'GuardrailCustomWordList', ], 'managedWordLists' => [ 'shape' => 'GuardrailManagedWordList', ], ], 'sensitive' => true, ], 'Identifier' => [ 'type' => 'string', 'max' => 1024, 'min' => 1, 'sensitive' => true, ], 'ImageBlock' => [ 'type' => 'structure', 'required' => [ 'format', 'source', ], 'members' => [ 'format' => [ 'shape' => 'ImageFormat', ], 'source' => [ 'shape' => 'ImageSource', ], ], ], 'ImageFormat' => [ 'type' => 'string', 'enum' => [ 'png', 'jpeg', 'gif', 'webp', ], ], 'ImageInput' => [ 'type' => 'structure', 'required' => [ 'format', 'source', ], 'members' => [ 'format' => [ 'shape' => 'ImageInputFormat', ], 'source' => [ 'shape' => 'ImageInputSource', ], ], ], 'ImageInputFormat' => [ 'type' => 'string', 'enum' => [ 'png', 'jpeg', 'gif', 'webp', ], ], 'ImageInputSource' => [ 'type' => 'structure', 'members' => [ 'bytes' => [ 'shape' => 'ImageInputSourceBytesBlob', ], ], 'union' => true, ], 'ImageInputSourceBytesBlob' => [ 'type' => 'blob', 'min' => 1, ], 'ImageInputs' => [ 'type' => 'list', 'member' => [ 'shape' => 'ImageInput', ], ], 'ImageSource' => [ 'type' => 'structure', 'members' => [ 'bytes' => [ 'shape' => 'ImageSourceBytesBlob', ], 's3Location' => [ 'shape' => 'S3Location', ], ], 'union' => true, ], 'ImageSourceBytesBlob' => [ 'type' => 'blob', 'min' => 1, ], 'ImplicitFilterConfiguration' => [ 'type' => 'structure', 'required' => [ 'metadataAttributes', 'modelArn', ], 'members' => [ 'metadataAttributes' => [ 'shape' => 'MetadataAttributeSchemaList', ], 'modelArn' => [ 'shape' => 'BedrockModelArn', ], ], ], 'InferenceConfig' => [ 'type' => 'structure', 'members' => [ 'textInferenceConfig' => [ 'shape' => 'TextInferenceConfig', ], ], ], 'InferenceConfiguration' => [ 'type' => 'structure', 'members' => [ 'temperature' => [ 'shape' => 'Temperature', ], 'topP' => [ 'shape' => 'TopP', ], 'topK' => [ 'shape' => 'TopK', ], 'maximumLength' => [ 'shape' => 'MaximumLength', ], 'stopSequences' => [ 'shape' => 'StopSequences', ], ], ], 'InlineAgentFilePart' => [ 'type' => 'structure', 'members' => [ 'files' => [ 'shape' => 'OutputFiles', ], ], 'event' => true, ], 'InlineAgentPayloadPart' => [ 'type' => 'structure', 'members' => [ 'bytes' => [ 'shape' => 'PartBody', ], 'attribution' => [ 'shape' => 'Attribution', ], ], 'event' => true, 'sensitive' => true, ], 'InlineAgentResponseStream' => [ 'type' => 'structure', 'members' => [ 'chunk' => [ 'shape' => 'InlineAgentPayloadPart', ], 'trace' => [ 'shape' => 'InlineAgentTracePart', ], 'returnControl' => [ 'shape' => 'InlineAgentReturnControlPayload', ], 'internalServerException' => [ 'shape' => 'InternalServerException', ], 'validationException' => [ 'shape' => 'ValidationException', ], 'resourceNotFoundException' => [ 'shape' => 'ResourceNotFoundException', ], 'serviceQuotaExceededException' => [ 'shape' => 'ServiceQuotaExceededException', ], 'throttlingException' => [ 'shape' => 'ThrottlingException', ], 'accessDeniedException' => [ 'shape' => 'AccessDeniedException', ], 'conflictException' => [ 'shape' => 'ConflictException', ], 'dependencyFailedException' => [ 'shape' => 'DependencyFailedException', ], 'badGatewayException' => [ 'shape' => 'BadGatewayException', ], 'files' => [ 'shape' => 'InlineAgentFilePart', ], ], 'eventstream' => true, ], 'InlineAgentReturnControlPayload' => [ 'type' => 'structure', 'members' => [ 'invocationInputs' => [ 'shape' => 'InvocationInputs', ], 'invocationId' => [ 'shape' => 'String', ], ], 'event' => true, 'sensitive' => true, ], 'InlineAgentTracePart' => [ 'type' => 'structure', 'members' => [ 'sessionId' => [ 'shape' => 'SessionId', ], 'trace' => [ 'shape' => 'Trace', ], 'callerChain' => [ 'shape' => 'CallerChain', ], 'eventTime' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'collaboratorName' => [ 'shape' => 'Name', ], ], 'event' => true, 'sensitive' => true, ], 'InlineBedrockModelConfigurations' => [ 'type' => 'structure', 'members' => [ 'performanceConfig' => [ 'shape' => 'PerformanceConfiguration', ], ], ], 'InlineSessionState' => [ 'type' => 'structure', 'members' => [ 'sessionAttributes' => [ 'shape' => 'SessionAttributesMap', ], 'promptSessionAttributes' => [ 'shape' => 'PromptSessionAttributesMap', ], 'returnControlInvocationResults' => [ 'shape' => 'ReturnControlInvocationResults', ], 'invocationId' => [ 'shape' => 'String', ], 'files' => [ 'shape' => 'InputFiles', ], 'conversationHistory' => [ 'shape' => 'ConversationHistory', ], ], ], 'InputFile' => [ 'type' => 'structure', 'required' => [ 'name', 'source', 'useCase', ], 'members' => [ 'name' => [ 'shape' => 'String', ], 'source' => [ 'shape' => 'FileSource', ], 'useCase' => [ 'shape' => 'FileUseCase', ], ], ], 'InputFiles' => [ 'type' => 'list', 'member' => [ 'shape' => 'InputFile', ], ], 'InputPrompt' => [ 'type' => 'structure', 'members' => [ 'textPrompt' => [ 'shape' => 'TextPrompt', ], ], 'union' => true, ], 'InputQueryType' => [ 'type' => 'string', 'enum' => [ 'TEXT', ], ], 'InputText' => [ 'type' => 'string', 'max' => 25000000, 'min' => 0, 'sensitive' => true, ], 'Instruction' => [ 'type' => 'string', 'min' => 40, 'sensitive' => true, ], 'Integer' => [ 'type' => 'integer', 'box' => true, ], 'InternalServerException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'NonBlankString', ], 'reason' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 500, ], 'exception' => true, 'fault' => true, ], 'InvocationDescription' => [ 'type' => 'string', 'max' => 200, 'min' => 1, ], 'InvocationIdentifier' => [ 'type' => 'string', 'pattern' => '[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}', ], 'InvocationInput' => [ 'type' => 'structure', 'members' => [ 'traceId' => [ 'shape' => 'TraceId', ], 'invocationType' => [ 'shape' => 'InvocationType', ], 'actionGroupInvocationInput' => [ 'shape' => 'ActionGroupInvocationInput', ], 'knowledgeBaseLookupInput' => [ 'shape' => 'KnowledgeBaseLookupInput', ], 'codeInterpreterInvocationInput' => [ 'shape' => 'CodeInterpreterInvocationInput', ], 'agentCollaboratorInvocationInput' => [ 'shape' => 'AgentCollaboratorInvocationInput', ], ], 'sensitive' => true, ], 'InvocationInputMember' => [ 'type' => 'structure', 'members' => [ 'apiInvocationInput' => [ 'shape' => 'ApiInvocationInput', ], 'functionInvocationInput' => [ 'shape' => 'FunctionInvocationInput', ], ], 'union' => true, ], 'InvocationInputs' => [ 'type' => 'list', 'member' => [ 'shape' => 'InvocationInputMember', ], 'max' => 5, 'min' => 1, ], 'InvocationResultMember' => [ 'type' => 'structure', 'members' => [ 'apiResult' => [ 'shape' => 'ApiResult', ], 'functionResult' => [ 'shape' => 'FunctionResult', ], ], 'union' => true, ], 'InvocationStep' => [ 'type' => 'structure', 'required' => [ 'sessionId', 'invocationId', 'invocationStepId', 'invocationStepTime', 'payload', ], 'members' => [ 'sessionId' => [ 'shape' => 'Uuid', ], 'invocationId' => [ 'shape' => 'Uuid', ], 'invocationStepId' => [ 'shape' => 'Uuid', ], 'invocationStepTime' => [ 'shape' => 'DateTimestamp', ], 'payload' => [ 'shape' => 'InvocationStepPayload', ], ], ], 'InvocationStepPayload' => [ 'type' => 'structure', 'members' => [ 'contentBlocks' => [ 'shape' => 'BedrockSessionContentBlocks', ], ], 'union' => true, ], 'InvocationStepSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'InvocationStepSummary', ], ], 'InvocationStepSummary' => [ 'type' => 'structure', 'required' => [ 'sessionId', 'invocationId', 'invocationStepId', 'invocationStepTime', ], 'members' => [ 'sessionId' => [ 'shape' => 'Uuid', ], 'invocationId' => [ 'shape' => 'Uuid', ], 'invocationStepId' => [ 'shape' => 'Uuid', ], 'invocationStepTime' => [ 'shape' => 'DateTimestamp', ], ], ], 'InvocationSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'InvocationSummary', ], ], 'InvocationSummary' => [ 'type' => 'structure', 'required' => [ 'sessionId', 'invocationId', 'createdAt', ], 'members' => [ 'sessionId' => [ 'shape' => 'Uuid', ], 'invocationId' => [ 'shape' => 'Uuid', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], ], ], 'InvocationType' => [ 'type' => 'string', 'enum' => [ 'ACTION_GROUP', 'KNOWLEDGE_BASE', 'FINISH', 'ACTION_GROUP_CODE_INTERPRETER', 'AGENT_COLLABORATOR', ], ], 'InvokeAgentRequest' => [ 'type' => 'structure', 'required' => [ 'agentId', 'agentAliasId', 'sessionId', ], 'members' => [ 'sessionState' => [ 'shape' => 'SessionState', ], 'agentId' => [ 'shape' => 'AgentId', 'location' => 'uri', 'locationName' => 'agentId', ], 'agentAliasId' => [ 'shape' => 'AgentAliasId', 'location' => 'uri', 'locationName' => 'agentAliasId', ], 'sessionId' => [ 'shape' => 'SessionId', 'location' => 'uri', 'locationName' => 'sessionId', ], 'endSession' => [ 'shape' => 'Boolean', ], 'enableTrace' => [ 'shape' => 'Boolean', ], 'inputText' => [ 'shape' => 'InputText', ], 'memoryId' => [ 'shape' => 'MemoryId', ], 'bedrockModelConfigurations' => [ 'shape' => 'BedrockModelConfigurations', ], 'streamingConfigurations' => [ 'shape' => 'StreamingConfigurations', ], 'promptCreationConfigurations' => [ 'shape' => 'PromptCreationConfigurations', ], 'sourceArn' => [ 'shape' => 'AWSResourceARN', 'location' => 'header', 'locationName' => 'x-amz-source-arn', ], ], ], 'InvokeAgentResponse' => [ 'type' => 'structure', 'required' => [ 'completion', 'contentType', 'sessionId', ], 'members' => [ 'completion' => [ 'shape' => 'ResponseStream', ], 'contentType' => [ 'shape' => 'MimeType', 'location' => 'header', 'locationName' => 'x-amzn-bedrock-agent-content-type', ], 'sessionId' => [ 'shape' => 'SessionId', 'location' => 'header', 'locationName' => 'x-amz-bedrock-agent-session-id', ], 'memoryId' => [ 'shape' => 'MemoryId', 'location' => 'header', 'locationName' => 'x-amz-bedrock-agent-memory-id', ], ], 'payload' => 'completion', ], 'InvokeFlowRequest' => [ 'type' => 'structure', 'required' => [ 'flowIdentifier', 'flowAliasIdentifier', 'inputs', ], 'members' => [ 'flowIdentifier' => [ 'shape' => 'FlowIdentifier', 'location' => 'uri', 'locationName' => 'flowIdentifier', ], 'flowAliasIdentifier' => [ 'shape' => 'FlowAliasIdentifier', 'location' => 'uri', 'locationName' => 'flowAliasIdentifier', ], 'inputs' => [ 'shape' => 'FlowInputs', ], 'enableTrace' => [ 'shape' => 'Boolean', ], 'modelPerformanceConfiguration' => [ 'shape' => 'ModelPerformanceConfiguration', ], 'executionId' => [ 'shape' => 'FlowExecutionId', ], ], ], 'InvokeFlowResponse' => [ 'type' => 'structure', 'required' => [ 'responseStream', ], 'members' => [ 'responseStream' => [ 'shape' => 'FlowResponseStream', ], 'executionId' => [ 'shape' => 'FlowExecutionId', 'location' => 'header', 'locationName' => 'x-amz-bedrock-flow-execution-id', ], ], 'payload' => 'responseStream', ], 'InvokeInlineAgentRequest' => [ 'type' => 'structure', 'required' => [ 'foundationModel', 'instruction', 'sessionId', ], 'members' => [ 'customerEncryptionKeyArn' => [ 'shape' => 'KmsKeyArn', ], 'foundationModel' => [ 'shape' => 'ModelIdentifier', ], 'instruction' => [ 'shape' => 'Instruction', ], 'idleSessionTTLInSeconds' => [ 'shape' => 'SessionTTL', ], 'actionGroups' => [ 'shape' => 'AgentActionGroups', ], 'knowledgeBases' => [ 'shape' => 'KnowledgeBases', ], 'guardrailConfiguration' => [ 'shape' => 'GuardrailConfigurationWithArn', ], 'promptOverrideConfiguration' => [ 'shape' => 'PromptOverrideConfiguration', ], 'agentCollaboration' => [ 'shape' => 'AgentCollaboration', ], 'collaboratorConfigurations' => [ 'shape' => 'CollaboratorConfigurations', ], 'agentName' => [ 'shape' => 'Name', ], 'sessionId' => [ 'shape' => 'SessionId', 'location' => 'uri', 'locationName' => 'sessionId', ], 'endSession' => [ 'shape' => 'Boolean', ], 'enableTrace' => [ 'shape' => 'Boolean', ], 'inputText' => [ 'shape' => 'InputText', ], 'streamingConfigurations' => [ 'shape' => 'StreamingConfigurations', ], 'promptCreationConfigurations' => [ 'shape' => 'PromptCreationConfigurations', ], 'inlineSessionState' => [ 'shape' => 'InlineSessionState', ], 'collaborators' => [ 'shape' => 'Collaborators', ], 'bedrockModelConfigurations' => [ 'shape' => 'InlineBedrockModelConfigurations', ], 'orchestrationType' => [ 'shape' => 'OrchestrationType', ], 'customOrchestration' => [ 'shape' => 'CustomOrchestration', ], ], ], 'InvokeInlineAgentResponse' => [ 'type' => 'structure', 'required' => [ 'completion', 'contentType', 'sessionId', ], 'members' => [ 'completion' => [ 'shape' => 'InlineAgentResponseStream', ], 'contentType' => [ 'shape' => 'MimeType', 'location' => 'header', 'locationName' => 'x-amzn-bedrock-agent-content-type', ], 'sessionId' => [ 'shape' => 'SessionId', 'location' => 'header', 'locationName' => 'x-amz-bedrock-agent-session-id', ], ], 'payload' => 'completion', ], 'KmsKeyArn' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, 'pattern' => 'arn:aws(|-cn|-us-gov):kms:[a-zA-Z0-9-]*:[0-9]{12}:key/[a-zA-Z0-9-]{36}', ], 'KnowledgeBase' => [ 'type' => 'structure', 'required' => [ 'knowledgeBaseId', 'description', ], 'members' => [ 'knowledgeBaseId' => [ 'shape' => 'KnowledgeBaseId', ], 'description' => [ 'shape' => 'ResourceDescription', ], 'retrievalConfiguration' => [ 'shape' => 'KnowledgeBaseRetrievalConfiguration', ], ], ], 'KnowledgeBaseArn' => [ 'type' => 'string', 'max' => 128, 'min' => 0, 'pattern' => 'arn:aws(|-cn|-us-gov):bedrock:[a-zA-Z0-9-]*:[0-9]{12}:knowledge-base/[0-9a-zA-Z]+', ], 'KnowledgeBaseConfiguration' => [ 'type' => 'structure', 'required' => [ 'knowledgeBaseId', 'retrievalConfiguration', ], 'members' => [ 'knowledgeBaseId' => [ 'shape' => 'KnowledgeBaseId', ], 'retrievalConfiguration' => [ 'shape' => 'KnowledgeBaseRetrievalConfiguration', ], ], ], 'KnowledgeBaseConfigurations' => [ 'type' => 'list', 'member' => [ 'shape' => 'KnowledgeBaseConfiguration', ], 'min' => 1, ], 'KnowledgeBaseId' => [ 'type' => 'string', 'max' => 10, 'min' => 0, 'pattern' => '[0-9a-zA-Z]+', ], 'KnowledgeBaseLookupInput' => [ 'type' => 'structure', 'members' => [ 'text' => [ 'shape' => 'KnowledgeBaseLookupInputString', ], 'knowledgeBaseId' => [ 'shape' => 'TraceKnowledgeBaseId', ], ], ], 'KnowledgeBaseLookupInputString' => [ 'type' => 'string', 'sensitive' => true, ], 'KnowledgeBaseLookupOutput' => [ 'type' => 'structure', 'members' => [ 'retrievedReferences' => [ 'shape' => 'RetrievedReferences', ], 'metadata' => [ 'shape' => 'Metadata', ], ], ], 'KnowledgeBaseQuery' => [ 'type' => 'structure', 'required' => [ 'text', ], 'members' => [ 'text' => [ 'shape' => 'KnowledgeBaseQueryTextString', ], ], 'sensitive' => true, ], 'KnowledgeBaseQueryTextString' => [ 'type' => 'string', 'max' => 1000, 'min' => 0, ], 'KnowledgeBaseRetrievalConfiguration' => [ 'type' => 'structure', 'required' => [ 'vectorSearchConfiguration', ], 'members' => [ 'vectorSearchConfiguration' => [ 'shape' => 'KnowledgeBaseVectorSearchConfiguration', ], ], ], 'KnowledgeBaseRetrievalResult' => [ 'type' => 'structure', 'required' => [ 'content', ], 'members' => [ 'content' => [ 'shape' => 'RetrievalResultContent', ], 'location' => [ 'shape' => 'RetrievalResultLocation', ], 'score' => [ 'shape' => 'Double', ], 'metadata' => [ 'shape' => 'RetrievalResultMetadata', ], ], ], 'KnowledgeBaseRetrievalResults' => [ 'type' => 'list', 'member' => [ 'shape' => 'KnowledgeBaseRetrievalResult', ], 'sensitive' => true, ], 'KnowledgeBaseRetrieveAndGenerateConfiguration' => [ 'type' => 'structure', 'required' => [ 'knowledgeBaseId', 'modelArn', ], 'members' => [ 'knowledgeBaseId' => [ 'shape' => 'KnowledgeBaseId', ], 'modelArn' => [ 'shape' => 'BedrockModelArn', ], 'retrievalConfiguration' => [ 'shape' => 'KnowledgeBaseRetrievalConfiguration', ], 'generationConfiguration' => [ 'shape' => 'GenerationConfiguration', ], 'orchestrationConfiguration' => [ 'shape' => 'OrchestrationConfiguration', ], ], ], 'KnowledgeBaseVectorSearchConfiguration' => [ 'type' => 'structure', 'members' => [ 'numberOfResults' => [ 'shape' => 'KnowledgeBaseVectorSearchConfigurationNumberOfResultsInteger', 'box' => true, ], 'overrideSearchType' => [ 'shape' => 'SearchType', ], 'filter' => [ 'shape' => 'RetrievalFilter', ], 'rerankingConfiguration' => [ 'shape' => 'VectorSearchRerankingConfiguration', ], 'implicitFilterConfiguration' => [ 'shape' => 'ImplicitFilterConfiguration', ], ], ], 'KnowledgeBaseVectorSearchConfigurationNumberOfResultsInteger' => [ 'type' => 'integer', 'box' => true, 'max' => 100, 'min' => 1, ], 'KnowledgeBases' => [ 'type' => 'list', 'member' => [ 'shape' => 'KnowledgeBase', ], ], 'LambdaArn' => [ 'type' => 'string', ], 'LambdaResourceArn' => [ 'type' => 'string', 'max' => 2048, 'min' => 0, 'pattern' => 'arn:(aws[a-zA-Z-]*)?:lambda:[a-z]{2}(-gov)?-[a-z]+-\\d{1}:\\d{12}:function:[a-zA-Z0-9-_\\.]+(:(\\$LATEST|[a-zA-Z0-9-_]+))?', ], 'ListFlowExecutionEventsRequest' => [ 'type' => 'structure', 'required' => [ 'flowIdentifier', 'flowAliasIdentifier', 'executionIdentifier', 'eventType', ], 'members' => [ 'flowIdentifier' => [ 'shape' => 'FlowIdentifier', 'location' => 'uri', 'locationName' => 'flowIdentifier', ], 'flowAliasIdentifier' => [ 'shape' => 'FlowAliasIdentifier', 'location' => 'uri', 'locationName' => 'flowAliasIdentifier', ], 'executionIdentifier' => [ 'shape' => 'FlowExecutionIdentifier', 'location' => 'uri', 'locationName' => 'executionIdentifier', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'eventType' => [ 'shape' => 'FlowExecutionEventType', 'location' => 'querystring', 'locationName' => 'eventType', ], ], ], 'ListFlowExecutionEventsResponse' => [ 'type' => 'structure', 'required' => [ 'flowExecutionEvents', ], 'members' => [ 'flowExecutionEvents' => [ 'shape' => 'FlowExecutionEvents', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListFlowExecutionsRequest' => [ 'type' => 'structure', 'required' => [ 'flowIdentifier', ], 'members' => [ 'flowIdentifier' => [ 'shape' => 'FlowIdentifier', 'location' => 'uri', 'locationName' => 'flowIdentifier', ], 'flowAliasIdentifier' => [ 'shape' => 'FlowAliasIdentifier', 'location' => 'querystring', 'locationName' => 'flowAliasIdentifier', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'ListFlowExecutionsResponse' => [ 'type' => 'structure', 'required' => [ 'flowExecutionSummaries', ], 'members' => [ 'flowExecutionSummaries' => [ 'shape' => 'FlowExecutionSummaries', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListInvocationStepsRequest' => [ 'type' => 'structure', 'required' => [ 'sessionIdentifier', ], 'members' => [ 'invocationIdentifier' => [ 'shape' => 'InvocationIdentifier', ], 'nextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'sessionIdentifier' => [ 'shape' => 'SessionIdentifier', 'location' => 'uri', 'locationName' => 'sessionIdentifier', ], ], ], 'ListInvocationStepsResponse' => [ 'type' => 'structure', 'required' => [ 'invocationStepSummaries', ], 'members' => [ 'invocationStepSummaries' => [ 'shape' => 'InvocationStepSummaries', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListInvocationsRequest' => [ 'type' => 'structure', 'required' => [ 'sessionIdentifier', ], 'members' => [ 'nextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'sessionIdentifier' => [ 'shape' => 'SessionIdentifier', 'location' => 'uri', 'locationName' => 'sessionIdentifier', ], ], ], 'ListInvocationsResponse' => [ 'type' => 'structure', 'required' => [ 'invocationSummaries', ], 'members' => [ 'invocationSummaries' => [ 'shape' => 'InvocationSummaries', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListSessionsRequest' => [ 'type' => 'structure', 'members' => [ 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'ListSessionsResponse' => [ 'type' => 'structure', 'required' => [ 'sessionSummaries', ], 'members' => [ 'sessionSummaries' => [ 'shape' => 'SessionSummaries', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListTagsForResourceRequest' => [ 'type' => 'structure', 'required' => [ 'resourceArn', ], 'members' => [ 'resourceArn' => [ 'shape' => 'TaggableResourcesArn', 'location' => 'uri', 'locationName' => 'resourceArn', ], ], ], 'ListTagsForResourceResponse' => [ 'type' => 'structure', 'members' => [ 'tags' => [ 'shape' => 'TagsMap', ], ], ], 'Long' => [ 'type' => 'long', 'box' => true, ], 'MaxResults' => [ 'type' => 'integer', 'box' => true, 'max' => 1000, 'min' => 1, ], 'MaxTokens' => [ 'type' => 'integer', 'box' => true, 'max' => 65536, 'min' => 0, ], 'MaximumLength' => [ 'type' => 'integer', 'box' => true, 'max' => 8192, 'min' => 0, ], 'Memories' => [ 'type' => 'list', 'member' => [ 'shape' => 'Memory', ], ], 'Memory' => [ 'type' => 'structure', 'members' => [ 'sessionSummary' => [ 'shape' => 'MemorySessionSummary', ], ], 'union' => true, ], 'MemoryId' => [ 'type' => 'string', 'max' => 100, 'min' => 2, 'pattern' => '[0-9a-zA-Z._:-]+', ], 'MemorySessionSummary' => [ 'type' => 'structure', 'members' => [ 'memoryId' => [ 'shape' => 'MemoryId', ], 'sessionId' => [ 'shape' => 'SessionId', ], 'sessionStartTime' => [ 'shape' => 'DateTimestamp', ], 'sessionExpiryTime' => [ 'shape' => 'DateTimestamp', ], 'summaryText' => [ 'shape' => 'SummaryText', ], ], ], 'MemoryType' => [ 'type' => 'string', 'enum' => [ 'SESSION_SUMMARY', ], ], 'Message' => [ 'type' => 'structure', 'required' => [ 'role', 'content', ], 'members' => [ 'role' => [ 'shape' => 'ConversationRole', ], 'content' => [ 'shape' => 'ContentBlocks', ], ], ], 'Messages' => [ 'type' => 'list', 'member' => [ 'shape' => 'Message', ], ], 'Metadata' => [ 'type' => 'structure', 'members' => [ 'startTime' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'endTime' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'totalTimeMs' => [ 'shape' => 'Long', ], 'operationTotalTimeMs' => [ 'shape' => 'Long', ], 'clientRequestId' => [ 'shape' => 'String', ], 'usage' => [ 'shape' => 'Usage', ], ], 'sensitive' => true, ], 'MetadataAttributeSchema' => [ 'type' => 'structure', 'required' => [ 'key', 'type', 'description', ], 'members' => [ 'key' => [ 'shape' => 'MetadataAttributeSchemaKeyString', ], 'type' => [ 'shape' => 'AttributeType', ], 'description' => [ 'shape' => 'MetadataAttributeSchemaDescriptionString', ], ], 'sensitive' => true, ], 'MetadataAttributeSchemaDescriptionString' => [ 'type' => 'string', 'max' => 1024, 'min' => 1, 'pattern' => '[\\s\\S]+', ], 'MetadataAttributeSchemaKeyString' => [ 'type' => 'string', 'max' => 256, 'min' => 1, 'pattern' => '[\\s\\S]+', ], 'MetadataAttributeSchemaList' => [ 'type' => 'list', 'member' => [ 'shape' => 'MetadataAttributeSchema', ], 'max' => 25, 'min' => 1, ], 'MetadataConfigurationForReranking' => [ 'type' => 'structure', 'required' => [ 'selectionMode', ], 'members' => [ 'selectionMode' => [ 'shape' => 'RerankingMetadataSelectionMode', ], 'selectiveModeConfiguration' => [ 'shape' => 'RerankingMetadataSelectiveModeConfiguration', ], ], ], 'MimeType' => [ 'type' => 'string', ], 'ModelIdentifier' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, 'pattern' => '.*(^arn:aws(-[^:]+)?:bedrock:[a-z0-9-]{1,20}:(([0-9]{12}:custom-model/[a-z0-9-]{1,63}[.]{1}[a-z0-9-]{1,63}(([:][a-z0-9-]{1,63}){0,2})?/[a-z0-9]{12})|(:foundation-model/([a-z0-9-]{1,63}[.]{1}[a-z0-9-]{1,63}([.]?[a-z0-9-]{1,63})([:][a-z0-9-]{1,63}){0,2})))|(([a-z0-9-]{1,63}[.]{1}[a-z0-9-]{1,63}([.]?[a-z0-9-]{1,63})([:][a-z0-9-]{1,63}){0,2}))|(([0-9a-zA-Z][_-]?)+))$|(^arn:aws(|-us-gov|-cn|-iso|-iso-b):bedrock:(|[0-9a-z-]{1,20}):(|[0-9]{12}):inference-profile/[a-zA-Z0-9-:.]+)', ], 'ModelInvocationInput' => [ 'type' => 'structure', 'members' => [ 'traceId' => [ 'shape' => 'TraceId', ], 'text' => [ 'shape' => 'PromptText', ], 'type' => [ 'shape' => 'PromptType', ], 'overrideLambda' => [ 'shape' => 'LambdaArn', ], 'promptCreationMode' => [ 'shape' => 'CreationMode', ], 'inferenceConfiguration' => [ 'shape' => 'InferenceConfiguration', ], 'parserMode' => [ 'shape' => 'CreationMode', ], 'foundationModel' => [ 'shape' => 'ModelIdentifier', ], ], 'sensitive' => true, ], 'ModelNotReadyException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'NonBlankString', ], ], 'error' => [ 'httpStatusCode' => 424, 'senderFault' => true, ], 'exception' => true, ], 'ModelPerformanceConfiguration' => [ 'type' => 'structure', 'members' => [ 'performanceConfig' => [ 'shape' => 'PerformanceConfiguration', ], ], ], 'Name' => [ 'type' => 'string', 'pattern' => '([0-9a-zA-Z][_-]?){1,100}', 'sensitive' => true, ], 'NextToken' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, 'pattern' => '\\S*', ], 'NodeActionEvent' => [ 'type' => 'structure', 'required' => [ 'nodeName', 'timestamp', 'requestId', 'serviceName', 'operationName', ], 'members' => [ 'nodeName' => [ 'shape' => 'NodeName', ], 'timestamp' => [ 'shape' => 'DateTimestamp', ], 'requestId' => [ 'shape' => 'String', ], 'serviceName' => [ 'shape' => 'String', ], 'operationName' => [ 'shape' => 'String', ], 'operationRequest' => [ 'shape' => 'Document', ], 'operationResponse' => [ 'shape' => 'Document', ], ], 'sensitive' => true, ], 'NodeDependencyEvent' => [ 'type' => 'structure', 'required' => [ 'nodeName', 'timestamp', 'traceElements', ], 'members' => [ 'nodeName' => [ 'shape' => 'NodeName', ], 'timestamp' => [ 'shape' => 'DateTimestamp', ], 'traceElements' => [ 'shape' => 'NodeTraceElements', ], ], 'sensitive' => true, ], 'NodeErrorCode' => [ 'type' => 'string', 'enum' => [ 'VALIDATION', 'DEPENDENCY_FAILED', 'BAD_GATEWAY', 'INTERNAL_SERVER', ], ], 'NodeExecutionContent' => [ 'type' => 'structure', 'members' => [ 'document' => [ 'shape' => 'Document', ], ], 'sensitive' => true, 'union' => true, ], 'NodeFailureEvent' => [ 'type' => 'structure', 'required' => [ 'nodeName', 'timestamp', 'errorCode', 'errorMessage', ], 'members' => [ 'nodeName' => [ 'shape' => 'NodeName', ], 'timestamp' => [ 'shape' => 'DateTimestamp', ], 'errorCode' => [ 'shape' => 'NodeErrorCode', ], 'errorMessage' => [ 'shape' => 'String', ], ], 'sensitive' => true, ], 'NodeInputEvent' => [ 'type' => 'structure', 'required' => [ 'nodeName', 'timestamp', 'fields', ], 'members' => [ 'nodeName' => [ 'shape' => 'NodeName', ], 'timestamp' => [ 'shape' => 'DateTimestamp', ], 'fields' => [ 'shape' => 'NodeInputFields', ], ], 'sensitive' => true, ], 'NodeInputExecutionChain' => [ 'type' => 'list', 'member' => [ 'shape' => 'NodeInputExecutionChainItem', ], ], 'NodeInputExecutionChainItem' => [ 'type' => 'structure', 'required' => [ 'nodeName', 'type', ], 'members' => [ 'nodeName' => [ 'shape' => 'NodeName', ], 'index' => [ 'shape' => 'Integer', ], 'type' => [ 'shape' => 'FlowControlNodeType', ], ], ], 'NodeInputField' => [ 'type' => 'structure', 'required' => [ 'name', 'content', ], 'members' => [ 'name' => [ 'shape' => 'NodeInputName', ], 'content' => [ 'shape' => 'NodeExecutionContent', ], 'source' => [ 'shape' => 'NodeInputSource', ], 'type' => [ 'shape' => 'FlowNodeIODataType', ], 'category' => [ 'shape' => 'FlowNodeInputCategory', ], 'executionChain' => [ 'shape' => 'NodeInputExecutionChain', ], ], 'sensitive' => true, ], 'NodeInputFields' => [ 'type' => 'list', 'member' => [ 'shape' => 'NodeInputField', ], 'max' => 5, 'min' => 1, ], 'NodeInputName' => [ 'type' => 'string', 'pattern' => '[a-zA-Z]([_]?[0-9a-zA-Z]){0,99}', ], 'NodeInputSource' => [ 'type' => 'structure', 'required' => [ 'nodeName', 'outputFieldName', 'expression', ], 'members' => [ 'nodeName' => [ 'shape' => 'NodeName', ], 'outputFieldName' => [ 'shape' => 'FlowNodeOutputName', ], 'expression' => [ 'shape' => 'FlowNodeInputExpression', ], ], ], 'NodeName' => [ 'type' => 'string', 'pattern' => '[a-zA-Z]([_]?[0-9a-zA-Z]){0,99}', ], 'NodeOutputEvent' => [ 'type' => 'structure', 'required' => [ 'nodeName', 'timestamp', 'fields', ], 'members' => [ 'nodeName' => [ 'shape' => 'NodeName', ], 'timestamp' => [ 'shape' => 'DateTimestamp', ], 'fields' => [ 'shape' => 'NodeOutputFields', ], ], 'sensitive' => true, ], 'NodeOutputField' => [ 'type' => 'structure', 'required' => [ 'name', 'content', ], 'members' => [ 'name' => [ 'shape' => 'NodeOutputName', ], 'content' => [ 'shape' => 'NodeExecutionContent', ], 'next' => [ 'shape' => 'NodeOutputNextList', ], 'type' => [ 'shape' => 'FlowNodeIODataType', ], ], 'sensitive' => true, ], 'NodeOutputFields' => [ 'type' => 'list', 'member' => [ 'shape' => 'NodeOutputField', ], 'max' => 2, 'min' => 1, ], 'NodeOutputName' => [ 'type' => 'string', 'pattern' => '[a-zA-Z]([_]?[0-9a-zA-Z]){0,99}', ], 'NodeOutputNext' => [ 'type' => 'structure', 'required' => [ 'nodeName', 'inputFieldName', ], 'members' => [ 'nodeName' => [ 'shape' => 'NodeName', ], 'inputFieldName' => [ 'shape' => 'FlowNodeInputName', ], ], 'sensitive' => true, ], 'NodeOutputNextList' => [ 'type' => 'list', 'member' => [ 'shape' => 'NodeOutputNext', ], ], 'NodeTraceElements' => [ 'type' => 'structure', 'members' => [ 'agentTraces' => [ 'shape' => 'AgentTraces', ], ], 'sensitive' => true, 'union' => true, ], 'NodeType' => [ 'type' => 'string', 'enum' => [ 'FlowInputNode', 'FlowOutputNode', 'LambdaFunctionNode', 'KnowledgeBaseNode', 'PromptNode', 'ConditionNode', 'LexNode', ], ], 'NonBlankString' => [ 'type' => 'string', 'pattern' => '[\\s\\S]*', ], 'Observation' => [ 'type' => 'structure', 'members' => [ 'traceId' => [ 'shape' => 'TraceId', ], 'type' => [ 'shape' => 'Type', ], 'actionGroupInvocationOutput' => [ 'shape' => 'ActionGroupInvocationOutput', ], 'agentCollaboratorInvocationOutput' => [ 'shape' => 'AgentCollaboratorInvocationOutput', ], 'knowledgeBaseLookupOutput' => [ 'shape' => 'KnowledgeBaseLookupOutput', ], 'finalResponse' => [ 'shape' => 'FinalResponse', ], 'repromptResponse' => [ 'shape' => 'RepromptResponse', ], 'codeInterpreterInvocationOutput' => [ 'shape' => 'CodeInterpreterInvocationOutput', ], ], 'sensitive' => true, ], 'OptimizePromptRequest' => [ 'type' => 'structure', 'required' => [ 'input', 'targetModelId', ], 'members' => [ 'input' => [ 'shape' => 'InputPrompt', ], 'targetModelId' => [ 'shape' => 'OptimizePromptRequestTargetModelIdString', ], ], ], 'OptimizePromptRequestTargetModelIdString' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, 'pattern' => '(arn:aws(-[^:]+)?:bedrock:[a-z0-9-]{1,20}:(([0-9]{12}:custom-model/[a-z0-9-]{1,63}[.]{1}[a-z0-9-]{1,63}/[a-z0-9]{12})|(:foundation-model/[a-z0-9-]{1,63}[.]{1}[a-z0-9-]{1,63}([.:]?[a-z0-9-]{1,63}))|([0-9]{12}:provisioned-model/[a-z0-9]{12})))|([a-z0-9-]{1,63}[.]{1}[a-z0-9-]{1,63}([.:]?[a-z0-9-]{1,63}))|(([0-9a-zA-Z][_-]?)+)', ], 'OptimizePromptResponse' => [ 'type' => 'structure', 'required' => [ 'optimizedPrompt', ], 'members' => [ 'optimizedPrompt' => [ 'shape' => 'OptimizedPromptStream', ], ], 'payload' => 'optimizedPrompt', ], 'OptimizedPrompt' => [ 'type' => 'structure', 'members' => [ 'textPrompt' => [ 'shape' => 'TextPrompt', ], ], 'union' => true, ], 'OptimizedPromptEvent' => [ 'type' => 'structure', 'members' => [ 'optimizedPrompt' => [ 'shape' => 'OptimizedPrompt', ], ], 'event' => true, 'sensitive' => true, ], 'OptimizedPromptStream' => [ 'type' => 'structure', 'members' => [ 'optimizedPromptEvent' => [ 'shape' => 'OptimizedPromptEvent', ], 'analyzePromptEvent' => [ 'shape' => 'AnalyzePromptEvent', ], 'internalServerException' => [ 'shape' => 'InternalServerException', ], 'throttlingException' => [ 'shape' => 'ThrottlingException', ], 'validationException' => [ 'shape' => 'ValidationException', ], 'dependencyFailedException' => [ 'shape' => 'DependencyFailedException', ], 'accessDeniedException' => [ 'shape' => 'AccessDeniedException', ], 'badGatewayException' => [ 'shape' => 'BadGatewayException', ], ], 'eventstream' => true, ], 'OrchestrationConfiguration' => [ 'type' => 'structure', 'members' => [ 'promptTemplate' => [ 'shape' => 'PromptTemplate', ], 'inferenceConfig' => [ 'shape' => 'InferenceConfig', ], 'additionalModelRequestFields' => [ 'shape' => 'AdditionalModelRequestFields', ], 'queryTransformationConfiguration' => [ 'shape' => 'QueryTransformationConfiguration', ], 'performanceConfig' => [ 'shape' => 'PerformanceConfiguration', ], ], ], 'OrchestrationExecutor' => [ 'type' => 'structure', 'members' => [ 'lambda' => [ 'shape' => 'LambdaArn', ], ], 'union' => true, ], 'OrchestrationModelInvocationOutput' => [ 'type' => 'structure', 'members' => [ 'traceId' => [ 'shape' => 'TraceId', ], 'rawResponse' => [ 'shape' => 'RawResponse', ], 'metadata' => [ 'shape' => 'Metadata', ], 'reasoningContent' => [ 'shape' => 'ReasoningContentBlock', ], ], 'sensitive' => true, ], 'OrchestrationTrace' => [ 'type' => 'structure', 'members' => [ 'rationale' => [ 'shape' => 'Rationale', ], 'invocationInput' => [ 'shape' => 'InvocationInput', ], 'observation' => [ 'shape' => 'Observation', ], 'modelInvocationInput' => [ 'shape' => 'ModelInvocationInput', ], 'modelInvocationOutput' => [ 'shape' => 'OrchestrationModelInvocationOutput', ], ], 'sensitive' => true, 'union' => true, ], 'OrchestrationType' => [ 'type' => 'string', 'enum' => [ 'DEFAULT', 'CUSTOM_ORCHESTRATION', ], ], 'OutputFile' => [ 'type' => 'structure', 'members' => [ 'name' => [ 'shape' => 'String', ], 'type' => [ 'shape' => 'MimeType', ], 'bytes' => [ 'shape' => 'FileBody', ], ], 'sensitive' => true, ], 'OutputFiles' => [ 'type' => 'list', 'member' => [ 'shape' => 'OutputFile', ], 'max' => 5, 'min' => 0, ], 'OutputString' => [ 'type' => 'string', 'sensitive' => true, ], 'Parameter' => [ 'type' => 'structure', 'members' => [ 'name' => [ 'shape' => 'String', ], 'type' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'String', ], ], ], 'ParameterDescription' => [ 'type' => 'string', 'max' => 500, 'min' => 1, ], 'ParameterDetail' => [ 'type' => 'structure', 'required' => [ 'type', ], 'members' => [ 'description' => [ 'shape' => 'ParameterDescription', ], 'type' => [ 'shape' => 'ParameterType', ], 'required' => [ 'shape' => 'Boolean', ], ], ], 'ParameterList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Parameter', ], ], 'ParameterMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'ParameterName', ], 'value' => [ 'shape' => 'ParameterDetail', ], ], 'ParameterName' => [ 'type' => 'string', 'pattern' => '([0-9a-zA-Z][_-]?){1,100}', ], 'ParameterType' => [ 'type' => 'string', 'enum' => [ 'string', 'number', 'integer', 'boolean', 'array', ], ], 'Parameters' => [ 'type' => 'list', 'member' => [ 'shape' => 'Parameter', ], ], 'PartBody' => [ 'type' => 'blob', 'max' => 1000000, 'min' => 0, 'sensitive' => true, ], 'Payload' => [ 'type' => 'string', 'sensitive' => true, ], 'PayloadPart' => [ 'type' => 'structure', 'members' => [ 'bytes' => [ 'shape' => 'PartBody', ], 'attribution' => [ 'shape' => 'Attribution', ], ], 'event' => true, 'sensitive' => true, ], 'PayloadType' => [ 'type' => 'string', 'enum' => [ 'TEXT', 'RETURN_CONTROL', ], ], 'PerformanceConfigLatency' => [ 'type' => 'string', 'enum' => [ 'standard', 'optimized', ], ], 'PerformanceConfiguration' => [ 'type' => 'structure', 'members' => [ 'latency' => [ 'shape' => 'PerformanceConfigLatency', ], ], ], 'PostProcessingModelInvocationOutput' => [ 'type' => 'structure', 'members' => [ 'traceId' => [ 'shape' => 'TraceId', ], 'parsedResponse' => [ 'shape' => 'PostProcessingParsedResponse', ], 'rawResponse' => [ 'shape' => 'RawResponse', ], 'metadata' => [ 'shape' => 'Metadata', ], 'reasoningContent' => [ 'shape' => 'ReasoningContentBlock', ], ], 'sensitive' => true, ], 'PostProcessingParsedResponse' => [ 'type' => 'structure', 'members' => [ 'text' => [ 'shape' => 'OutputString', ], ], 'sensitive' => true, ], 'PostProcessingTrace' => [ 'type' => 'structure', 'members' => [ 'modelInvocationInput' => [ 'shape' => 'ModelInvocationInput', ], 'modelInvocationOutput' => [ 'shape' => 'PostProcessingModelInvocationOutput', ], ], 'sensitive' => true, 'union' => true, ], 'PreProcessingModelInvocationOutput' => [ 'type' => 'structure', 'members' => [ 'traceId' => [ 'shape' => 'TraceId', ], 'parsedResponse' => [ 'shape' => 'PreProcessingParsedResponse', ], 'rawResponse' => [ 'shape' => 'RawResponse', ], 'metadata' => [ 'shape' => 'Metadata', ], 'reasoningContent' => [ 'shape' => 'ReasoningContentBlock', ], ], 'sensitive' => true, ], 'PreProcessingParsedResponse' => [ 'type' => 'structure', 'members' => [ 'rationale' => [ 'shape' => 'RationaleString', ], 'isValid' => [ 'shape' => 'Boolean', ], ], 'sensitive' => true, ], 'PreProcessingTrace' => [ 'type' => 'structure', 'members' => [ 'modelInvocationInput' => [ 'shape' => 'ModelInvocationInput', ], 'modelInvocationOutput' => [ 'shape' => 'PreProcessingModelInvocationOutput', ], ], 'sensitive' => true, 'union' => true, ], 'PromptConfiguration' => [ 'type' => 'structure', 'members' => [ 'promptType' => [ 'shape' => 'PromptType', ], 'promptCreationMode' => [ 'shape' => 'CreationMode', ], 'promptState' => [ 'shape' => 'PromptState', ], 'basePromptTemplate' => [ 'shape' => 'BasePromptTemplate', ], 'inferenceConfiguration' => [ 'shape' => 'InferenceConfiguration', ], 'parserMode' => [ 'shape' => 'CreationMode', ], 'foundationModel' => [ 'shape' => 'ModelIdentifier', ], 'additionalModelRequestFields' => [ 'shape' => 'Document', ], ], ], 'PromptConfigurations' => [ 'type' => 'list', 'member' => [ 'shape' => 'PromptConfiguration', ], 'max' => 10, 'min' => 0, ], 'PromptCreationConfigurations' => [ 'type' => 'structure', 'members' => [ 'previousConversationTurnsToInclude' => [ 'shape' => 'PromptCreationConfigurationsPreviousConversationTurnsToIncludeInteger', ], 'excludePreviousThinkingSteps' => [ 'shape' => 'Boolean', ], ], ], 'PromptCreationConfigurationsPreviousConversationTurnsToIncludeInteger' => [ 'type' => 'integer', 'box' => true, 'min' => 0, ], 'PromptOverrideConfiguration' => [ 'type' => 'structure', 'required' => [ 'promptConfigurations', ], 'members' => [ 'promptConfigurations' => [ 'shape' => 'PromptConfigurations', ], 'overrideLambda' => [ 'shape' => 'LambdaResourceArn', ], ], 'sensitive' => true, ], 'PromptSessionAttributesMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'String', ], ], 'PromptState' => [ 'type' => 'string', 'enum' => [ 'ENABLED', 'DISABLED', ], ], 'PromptTemplate' => [ 'type' => 'structure', 'members' => [ 'textPromptTemplate' => [ 'shape' => 'TextPromptTemplate', ], ], ], 'PromptText' => [ 'type' => 'string', 'sensitive' => true, ], 'PromptType' => [ 'type' => 'string', 'enum' => [ 'PRE_PROCESSING', 'ORCHESTRATION', 'KNOWLEDGE_BASE_RESPONSE_GENERATION', 'POST_PROCESSING', 'ROUTING_CLASSIFIER', ], ], 'PropertyParameters' => [ 'type' => 'structure', 'members' => [ 'properties' => [ 'shape' => 'ParameterList', ], ], ], 'PutInvocationStepRequest' => [ 'type' => 'structure', 'required' => [ 'sessionIdentifier', 'invocationIdentifier', 'invocationStepTime', 'payload', ], 'members' => [ 'sessionIdentifier' => [ 'shape' => 'SessionIdentifier', 'location' => 'uri', 'locationName' => 'sessionIdentifier', ], 'invocationIdentifier' => [ 'shape' => 'InvocationIdentifier', ], 'invocationStepTime' => [ 'shape' => 'DateTimestamp', ], 'payload' => [ 'shape' => 'InvocationStepPayload', ], 'invocationStepId' => [ 'shape' => 'Uuid', ], ], ], 'PutInvocationStepResponse' => [ 'type' => 'structure', 'required' => [ 'invocationStepId', ], 'members' => [ 'invocationStepId' => [ 'shape' => 'Uuid', ], ], ], 'QueryGenerationInput' => [ 'type' => 'structure', 'required' => [ 'type', 'text', ], 'members' => [ 'type' => [ 'shape' => 'InputQueryType', ], 'text' => [ 'shape' => 'QueryGenerationInputTextString', ], ], 'sensitive' => true, ], 'QueryGenerationInputTextString' => [ 'type' => 'string', 'max' => 20000, 'min' => 1, ], 'QueryTransformationConfiguration' => [ 'type' => 'structure', 'required' => [ 'type', ], 'members' => [ 'type' => [ 'shape' => 'QueryTransformationType', ], ], ], 'QueryTransformationMode' => [ 'type' => 'string', 'enum' => [ 'TEXT_TO_SQL', ], ], 'QueryTransformationType' => [ 'type' => 'string', 'enum' => [ 'QUERY_DECOMPOSITION', ], ], 'RAGStopSequences' => [ 'type' => 'list', 'member' => [ 'shape' => 'RAGStopSequencesMemberString', ], 'max' => 4, 'min' => 0, ], 'RAGStopSequencesMemberString' => [ 'type' => 'string', 'max' => 1000, 'min' => 1, ], 'Rationale' => [ 'type' => 'structure', 'members' => [ 'traceId' => [ 'shape' => 'TraceId', ], 'text' => [ 'shape' => 'RationaleString', ], ], 'sensitive' => true, ], 'RationaleString' => [ 'type' => 'string', 'sensitive' => true, ], 'RawResponse' => [ 'type' => 'structure', 'members' => [ 'content' => [ 'shape' => 'String', ], ], 'sensitive' => true, ], 'ReasoningContentBlock' => [ 'type' => 'structure', 'members' => [ 'reasoningText' => [ 'shape' => 'ReasoningTextBlock', ], 'redactedContent' => [ 'shape' => 'Blob', ], ], 'sensitive' => true, 'union' => true, ], 'ReasoningTextBlock' => [ 'type' => 'structure', 'required' => [ 'text', ], 'members' => [ 'text' => [ 'shape' => 'String', ], 'signature' => [ 'shape' => 'String', ], ], 'sensitive' => true, ], 'RelayConversationHistory' => [ 'type' => 'string', 'enum' => [ 'TO_COLLABORATOR', 'DISABLED', ], ], 'RepromptResponse' => [ 'type' => 'structure', 'members' => [ 'text' => [ 'shape' => 'String', ], 'source' => [ 'shape' => 'Source', ], ], 'sensitive' => true, ], 'RequestBody' => [ 'type' => 'structure', 'members' => [ 'content' => [ 'shape' => 'ContentMap', ], ], ], 'RequireConfirmation' => [ 'type' => 'string', 'enum' => [ 'ENABLED', 'DISABLED', ], ], 'RerankDocument' => [ 'type' => 'structure', 'required' => [ 'type', ], 'members' => [ 'type' => [ 'shape' => 'RerankDocumentType', ], 'textDocument' => [ 'shape' => 'RerankTextDocument', ], 'jsonDocument' => [ 'shape' => 'Document', ], ], 'sensitive' => true, ], 'RerankDocumentType' => [ 'type' => 'string', 'enum' => [ 'TEXT', 'JSON', ], ], 'RerankQueriesList' => [ 'type' => 'list', 'member' => [ 'shape' => 'RerankQuery', ], 'max' => 1, 'min' => 1, 'sensitive' => true, ], 'RerankQuery' => [ 'type' => 'structure', 'required' => [ 'type', 'textQuery', ], 'members' => [ 'type' => [ 'shape' => 'RerankQueryContentType', ], 'textQuery' => [ 'shape' => 'RerankTextDocument', ], ], 'sensitive' => true, ], 'RerankQueryContentType' => [ 'type' => 'string', 'enum' => [ 'TEXT', ], ], 'RerankRequest' => [ 'type' => 'structure', 'required' => [ 'queries', 'sources', 'rerankingConfiguration', ], 'members' => [ 'queries' => [ 'shape' => 'RerankQueriesList', ], 'sources' => [ 'shape' => 'RerankSourcesList', ], 'rerankingConfiguration' => [ 'shape' => 'RerankingConfiguration', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'RerankResponse' => [ 'type' => 'structure', 'required' => [ 'results', ], 'members' => [ 'results' => [ 'shape' => 'RerankResultsList', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'RerankResult' => [ 'type' => 'structure', 'required' => [ 'index', 'relevanceScore', ], 'members' => [ 'index' => [ 'shape' => 'RerankResultIndexInteger', ], 'relevanceScore' => [ 'shape' => 'Float', ], 'document' => [ 'shape' => 'RerankDocument', ], ], ], 'RerankResultIndexInteger' => [ 'type' => 'integer', 'box' => true, 'max' => 1000, 'min' => 0, ], 'RerankResultsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'RerankResult', ], ], 'RerankSource' => [ 'type' => 'structure', 'required' => [ 'type', 'inlineDocumentSource', ], 'members' => [ 'type' => [ 'shape' => 'RerankSourceType', ], 'inlineDocumentSource' => [ 'shape' => 'RerankDocument', ], ], 'sensitive' => true, ], 'RerankSourceType' => [ 'type' => 'string', 'enum' => [ 'INLINE', ], ], 'RerankSourcesList' => [ 'type' => 'list', 'member' => [ 'shape' => 'RerankSource', ], 'max' => 1000, 'min' => 1, 'sensitive' => true, ], 'RerankTextDocument' => [ 'type' => 'structure', 'members' => [ 'text' => [ 'shape' => 'RerankTextDocumentTextString', ], ], 'sensitive' => true, ], 'RerankTextDocumentTextString' => [ 'type' => 'string', 'max' => 32000, 'min' => 1, ], 'RerankingConfiguration' => [ 'type' => 'structure', 'required' => [ 'type', 'bedrockRerankingConfiguration', ], 'members' => [ 'type' => [ 'shape' => 'RerankingConfigurationType', ], 'bedrockRerankingConfiguration' => [ 'shape' => 'BedrockRerankingConfiguration', ], ], ], 'RerankingConfigurationType' => [ 'type' => 'string', 'enum' => [ 'BEDROCK_RERANKING_MODEL', ], ], 'RerankingMetadataSelectionMode' => [ 'type' => 'string', 'enum' => [ 'SELECTIVE', 'ALL', ], ], 'RerankingMetadataSelectiveModeConfiguration' => [ 'type' => 'structure', 'members' => [ 'fieldsToInclude' => [ 'shape' => 'FieldsForReranking', ], 'fieldsToExclude' => [ 'shape' => 'FieldsForReranking', ], ], 'union' => true, ], 'ResourceDescription' => [ 'type' => 'string', 'max' => 200, 'min' => 1, 'sensitive' => true, ], 'ResourceName' => [ 'type' => 'string', 'pattern' => '([0-9a-zA-Z][_-]?){1,100}', 'sensitive' => true, ], 'ResourceNotFoundException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'NonBlankString', ], ], 'error' => [ 'httpStatusCode' => 404, 'senderFault' => true, ], 'exception' => true, ], 'ResponseBody' => [ 'type' => 'map', 'key' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'ContentBody', ], ], 'ResponseState' => [ 'type' => 'string', 'enum' => [ 'FAILURE', 'REPROMPT', ], ], 'ResponseStream' => [ 'type' => 'structure', 'members' => [ 'chunk' => [ 'shape' => 'PayloadPart', ], 'trace' => [ 'shape' => 'TracePart', ], 'returnControl' => [ 'shape' => 'ReturnControlPayload', ], 'internalServerException' => [ 'shape' => 'InternalServerException', ], 'validationException' => [ 'shape' => 'ValidationException', ], 'resourceNotFoundException' => [ 'shape' => 'ResourceNotFoundException', ], 'serviceQuotaExceededException' => [ 'shape' => 'ServiceQuotaExceededException', ], 'throttlingException' => [ 'shape' => 'ThrottlingException', ], 'accessDeniedException' => [ 'shape' => 'AccessDeniedException', ], 'conflictException' => [ 'shape' => 'ConflictException', ], 'dependencyFailedException' => [ 'shape' => 'DependencyFailedException', ], 'badGatewayException' => [ 'shape' => 'BadGatewayException', ], 'modelNotReadyException' => [ 'shape' => 'ModelNotReadyException', ], 'files' => [ 'shape' => 'FilePart', ], ], 'eventstream' => true, ], 'RetrievalFilter' => [ 'type' => 'structure', 'members' => [ 'equals' => [ 'shape' => 'FilterAttribute', ], 'notEquals' => [ 'shape' => 'FilterAttribute', ], 'greaterThan' => [ 'shape' => 'FilterAttribute', ], 'greaterThanOrEquals' => [ 'shape' => 'FilterAttribute', ], 'lessThan' => [ 'shape' => 'FilterAttribute', ], 'lessThanOrEquals' => [ 'shape' => 'FilterAttribute', ], 'in' => [ 'shape' => 'FilterAttribute', ], 'notIn' => [ 'shape' => 'FilterAttribute', ], 'startsWith' => [ 'shape' => 'FilterAttribute', ], 'listContains' => [ 'shape' => 'FilterAttribute', ], 'stringContains' => [ 'shape' => 'FilterAttribute', ], 'andAll' => [ 'shape' => 'RetrievalFilterList', ], 'orAll' => [ 'shape' => 'RetrievalFilterList', ], ], 'sensitive' => true, 'union' => true, ], 'RetrievalFilterList' => [ 'type' => 'list', 'member' => [ 'shape' => 'RetrievalFilter', ], 'min' => 2, ], 'RetrievalResultConfluenceLocation' => [ 'type' => 'structure', 'members' => [ 'url' => [ 'shape' => 'String', ], ], ], 'RetrievalResultContent' => [ 'type' => 'structure', 'members' => [ 'type' => [ 'shape' => 'RetrievalResultContentType', ], 'text' => [ 'shape' => 'String', ], 'byteContent' => [ 'shape' => 'String', ], 'row' => [ 'shape' => 'RetrievalResultContentRow', ], ], 'sensitive' => true, ], 'RetrievalResultContentColumn' => [ 'type' => 'structure', 'members' => [ 'columnName' => [ 'shape' => 'String', ], 'columnValue' => [ 'shape' => 'String', ], 'type' => [ 'shape' => 'RetrievalResultContentColumnType', ], ], 'sensitive' => true, ], 'RetrievalResultContentColumnType' => [ 'type' => 'string', 'enum' => [ 'BLOB', 'BOOLEAN', 'DOUBLE', 'NULL', 'LONG', 'STRING', ], ], 'RetrievalResultContentRow' => [ 'type' => 'list', 'member' => [ 'shape' => 'RetrievalResultContentColumn', ], 'sensitive' => true, ], 'RetrievalResultContentType' => [ 'type' => 'string', 'enum' => [ 'TEXT', 'IMAGE', 'ROW', ], ], 'RetrievalResultCustomDocumentLocation' => [ 'type' => 'structure', 'members' => [ 'id' => [ 'shape' => 'String', ], ], ], 'RetrievalResultKendraDocumentLocation' => [ 'type' => 'structure', 'members' => [ 'uri' => [ 'shape' => 'String', ], ], ], 'RetrievalResultLocation' => [ 'type' => 'structure', 'required' => [ 'type', ], 'members' => [ 'type' => [ 'shape' => 'RetrievalResultLocationType', ], 's3Location' => [ 'shape' => 'RetrievalResultS3Location', ], 'webLocation' => [ 'shape' => 'RetrievalResultWebLocation', ], 'confluenceLocation' => [ 'shape' => 'RetrievalResultConfluenceLocation', ], 'salesforceLocation' => [ 'shape' => 'RetrievalResultSalesforceLocation', ], 'sharePointLocation' => [ 'shape' => 'RetrievalResultSharePointLocation', ], 'customDocumentLocation' => [ 'shape' => 'RetrievalResultCustomDocumentLocation', ], 'kendraDocumentLocation' => [ 'shape' => 'RetrievalResultKendraDocumentLocation', ], 'sqlLocation' => [ 'shape' => 'RetrievalResultSqlLocation', ], ], 'sensitive' => true, ], 'RetrievalResultLocationType' => [ 'type' => 'string', 'enum' => [ 'S3', 'WEB', 'CONFLUENCE', 'SALESFORCE', 'SHAREPOINT', 'CUSTOM', 'KENDRA', 'SQL', ], ], 'RetrievalResultMetadata' => [ 'type' => 'map', 'key' => [ 'shape' => 'RetrievalResultMetadataKey', ], 'value' => [ 'shape' => 'RetrievalResultMetadataValue', ], 'min' => 1, 'sensitive' => true, ], 'RetrievalResultMetadataKey' => [ 'type' => 'string', 'max' => 100, 'min' => 1, ], 'RetrievalResultMetadataValue' => [ 'type' => 'structure', 'members' => [], 'document' => true, ], 'RetrievalResultS3Location' => [ 'type' => 'structure', 'members' => [ 'uri' => [ 'shape' => 'String', ], ], ], 'RetrievalResultSalesforceLocation' => [ 'type' => 'structure', 'members' => [ 'url' => [ 'shape' => 'String', ], ], ], 'RetrievalResultSharePointLocation' => [ 'type' => 'structure', 'members' => [ 'url' => [ 'shape' => 'String', ], ], ], 'RetrievalResultSqlLocation' => [ 'type' => 'structure', 'members' => [ 'query' => [ 'shape' => 'String', ], ], ], 'RetrievalResultWebLocation' => [ 'type' => 'structure', 'members' => [ 'url' => [ 'shape' => 'String', ], ], ], 'RetrieveAndGenerateConfiguration' => [ 'type' => 'structure', 'required' => [ 'type', ], 'members' => [ 'type' => [ 'shape' => 'RetrieveAndGenerateType', ], 'knowledgeBaseConfiguration' => [ 'shape' => 'KnowledgeBaseRetrieveAndGenerateConfiguration', ], 'externalSourcesConfiguration' => [ 'shape' => 'ExternalSourcesRetrieveAndGenerateConfiguration', ], ], ], 'RetrieveAndGenerateInput' => [ 'type' => 'structure', 'required' => [ 'text', ], 'members' => [ 'text' => [ 'shape' => 'RetrieveAndGenerateInputTextString', ], ], 'sensitive' => true, ], 'RetrieveAndGenerateInputTextString' => [ 'type' => 'string', 'max' => 1000, 'min' => 0, ], 'RetrieveAndGenerateOutput' => [ 'type' => 'structure', 'required' => [ 'text', ], 'members' => [ 'text' => [ 'shape' => 'String', ], ], 'sensitive' => true, ], 'RetrieveAndGenerateOutputEvent' => [ 'type' => 'structure', 'required' => [ 'text', ], 'members' => [ 'text' => [ 'shape' => 'String', ], ], 'event' => true, 'sensitive' => true, ], 'RetrieveAndGenerateRequest' => [ 'type' => 'structure', 'required' => [ 'input', ], 'members' => [ 'sessionId' => [ 'shape' => 'SessionId', ], 'input' => [ 'shape' => 'RetrieveAndGenerateInput', ], 'retrieveAndGenerateConfiguration' => [ 'shape' => 'RetrieveAndGenerateConfiguration', ], 'sessionConfiguration' => [ 'shape' => 'RetrieveAndGenerateSessionConfiguration', ], ], ], 'RetrieveAndGenerateResponse' => [ 'type' => 'structure', 'required' => [ 'sessionId', 'output', ], 'members' => [ 'sessionId' => [ 'shape' => 'SessionId', ], 'output' => [ 'shape' => 'RetrieveAndGenerateOutput', ], 'citations' => [ 'shape' => 'Citations', ], 'guardrailAction' => [ 'shape' => 'GuadrailAction', ], ], ], 'RetrieveAndGenerateSessionConfiguration' => [ 'type' => 'structure', 'required' => [ 'kmsKeyArn', ], 'members' => [ 'kmsKeyArn' => [ 'shape' => 'KmsKeyArn', ], ], ], 'RetrieveAndGenerateStreamRequest' => [ 'type' => 'structure', 'required' => [ 'input', ], 'members' => [ 'sessionId' => [ 'shape' => 'SessionId', ], 'input' => [ 'shape' => 'RetrieveAndGenerateInput', ], 'retrieveAndGenerateConfiguration' => [ 'shape' => 'RetrieveAndGenerateConfiguration', ], 'sessionConfiguration' => [ 'shape' => 'RetrieveAndGenerateSessionConfiguration', ], ], ], 'RetrieveAndGenerateStreamResponse' => [ 'type' => 'structure', 'required' => [ 'stream', 'sessionId', ], 'members' => [ 'stream' => [ 'shape' => 'RetrieveAndGenerateStreamResponseOutput', ], 'sessionId' => [ 'shape' => 'SessionId', 'location' => 'header', 'locationName' => 'x-amzn-bedrock-knowledge-base-session-id', ], ], 'payload' => 'stream', ], 'RetrieveAndGenerateStreamResponseOutput' => [ 'type' => 'structure', 'members' => [ 'output' => [ 'shape' => 'RetrieveAndGenerateOutputEvent', ], 'citation' => [ 'shape' => 'CitationEvent', ], 'guardrail' => [ 'shape' => 'GuardrailEvent', ], 'internalServerException' => [ 'shape' => 'InternalServerException', ], 'validationException' => [ 'shape' => 'ValidationException', ], 'resourceNotFoundException' => [ 'shape' => 'ResourceNotFoundException', ], 'serviceQuotaExceededException' => [ 'shape' => 'ServiceQuotaExceededException', ], 'throttlingException' => [ 'shape' => 'ThrottlingException', ], 'accessDeniedException' => [ 'shape' => 'AccessDeniedException', ], 'conflictException' => [ 'shape' => 'ConflictException', ], 'dependencyFailedException' => [ 'shape' => 'DependencyFailedException', ], 'badGatewayException' => [ 'shape' => 'BadGatewayException', ], ], 'eventstream' => true, ], 'RetrieveAndGenerateType' => [ 'type' => 'string', 'enum' => [ 'KNOWLEDGE_BASE', 'EXTERNAL_SOURCES', ], ], 'RetrieveRequest' => [ 'type' => 'structure', 'required' => [ 'knowledgeBaseId', 'retrievalQuery', ], 'members' => [ 'knowledgeBaseId' => [ 'shape' => 'KnowledgeBaseId', 'location' => 'uri', 'locationName' => 'knowledgeBaseId', ], 'retrievalQuery' => [ 'shape' => 'KnowledgeBaseQuery', ], 'retrievalConfiguration' => [ 'shape' => 'KnowledgeBaseRetrievalConfiguration', ], 'guardrailConfiguration' => [ 'shape' => 'GuardrailConfiguration', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'RetrieveResponse' => [ 'type' => 'structure', 'required' => [ 'retrievalResults', ], 'members' => [ 'retrievalResults' => [ 'shape' => 'KnowledgeBaseRetrievalResults', ], 'guardrailAction' => [ 'shape' => 'GuadrailAction', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'RetrievedReference' => [ 'type' => 'structure', 'members' => [ 'content' => [ 'shape' => 'RetrievalResultContent', ], 'location' => [ 'shape' => 'RetrievalResultLocation', ], 'metadata' => [ 'shape' => 'RetrievalResultMetadata', ], ], ], 'RetrievedReferences' => [ 'type' => 'list', 'member' => [ 'shape' => 'RetrievedReference', ], ], 'ReturnControlInvocationResults' => [ 'type' => 'list', 'member' => [ 'shape' => 'InvocationResultMember', ], 'max' => 5, 'min' => 1, ], 'ReturnControlPayload' => [ 'type' => 'structure', 'members' => [ 'invocationInputs' => [ 'shape' => 'InvocationInputs', ], 'invocationId' => [ 'shape' => 'String', ], ], 'event' => true, 'sensitive' => true, ], 'ReturnControlResults' => [ 'type' => 'structure', 'members' => [ 'invocationId' => [ 'shape' => 'String', ], 'returnControlInvocationResults' => [ 'shape' => 'ReturnControlInvocationResults', ], ], ], 'RoutingClassifierModelInvocationOutput' => [ 'type' => 'structure', 'members' => [ 'traceId' => [ 'shape' => 'TraceId', ], 'rawResponse' => [ 'shape' => 'RawResponse', ], 'metadata' => [ 'shape' => 'Metadata', ], ], 'sensitive' => true, ], 'RoutingClassifierTrace' => [ 'type' => 'structure', 'members' => [ 'invocationInput' => [ 'shape' => 'InvocationInput', ], 'observation' => [ 'shape' => 'Observation', ], 'modelInvocationInput' => [ 'shape' => 'ModelInvocationInput', ], 'modelInvocationOutput' => [ 'shape' => 'RoutingClassifierModelInvocationOutput', ], ], 'sensitive' => true, 'union' => true, ], 'S3BucketName' => [ 'type' => 'string', 'max' => 63, 'min' => 3, 'pattern' => '[a-z0-9][\\.\\-a-z0-9]{1,61}[a-z0-9]', ], 'S3Identifier' => [ 'type' => 'structure', 'members' => [ 's3BucketName' => [ 'shape' => 'S3BucketName', ], 's3ObjectKey' => [ 'shape' => 'S3ObjectKey', ], ], ], 'S3Location' => [ 'type' => 'structure', 'required' => [ 'uri', ], 'members' => [ 'uri' => [ 'shape' => 'S3Uri', ], ], ], 'S3ObjectDoc' => [ 'type' => 'structure', 'required' => [ 'uri', ], 'members' => [ 'uri' => [ 'shape' => 'S3Uri', ], ], ], 'S3ObjectFile' => [ 'type' => 'structure', 'required' => [ 'uri', ], 'members' => [ 'uri' => [ 'shape' => 'S3Uri', ], ], ], 'S3ObjectKey' => [ 'type' => 'string', 'max' => 1024, 'min' => 1, 'pattern' => '[\\.\\-\\!\\*\\_\\\'\\(\\)a-zA-Z0-9][\\.\\-\\!\\*\\_\\\'\\(\\)\\/a-zA-Z0-9]*', ], 'S3Uri' => [ 'type' => 'string', 'max' => 1024, 'min' => 1, 'pattern' => 's3://[a-z0-9][a-z0-9.-]{1,61}[a-z0-9]/.{1,1024}', ], 'SatisfiedCondition' => [ 'type' => 'structure', 'required' => [ 'conditionName', ], 'members' => [ 'conditionName' => [ 'shape' => 'String', ], ], 'sensitive' => true, ], 'SatisfiedConditions' => [ 'type' => 'list', 'member' => [ 'shape' => 'SatisfiedCondition', ], 'max' => 5, 'min' => 1, ], 'SearchType' => [ 'type' => 'string', 'enum' => [ 'HYBRID', 'SEMANTIC', ], ], 'ServiceQuotaExceededException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'NonBlankString', ], ], 'error' => [ 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'SessionArn' => [ 'type' => 'string', 'pattern' => 'arn:aws(-[^:]+)?:bedrock:[a-z0-9-]+:[0-9]{12}:session/[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}', ], 'SessionAttributesMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'String', ], ], 'SessionId' => [ 'type' => 'string', 'max' => 100, 'min' => 2, 'pattern' => '[0-9a-zA-Z._:-]+', ], 'SessionIdentifier' => [ 'type' => 'string', 'pattern' => '(arn:aws(-[^:]+)?:bedrock:[a-z0-9-]+:[0-9]{12}:session/[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12})|([a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12})', ], 'SessionMetadataKey' => [ 'type' => 'string', 'max' => 100, 'min' => 1, ], 'SessionMetadataMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'SessionMetadataKey', ], 'value' => [ 'shape' => 'SessionMetadataValue', ], 'max' => 50, 'min' => 0, ], 'SessionMetadataValue' => [ 'type' => 'string', 'max' => 5000, 'min' => 0, ], 'SessionState' => [ 'type' => 'structure', 'members' => [ 'sessionAttributes' => [ 'shape' => 'SessionAttributesMap', ], 'promptSessionAttributes' => [ 'shape' => 'PromptSessionAttributesMap', ], 'returnControlInvocationResults' => [ 'shape' => 'ReturnControlInvocationResults', ], 'invocationId' => [ 'shape' => 'String', ], 'files' => [ 'shape' => 'InputFiles', ], 'knowledgeBaseConfigurations' => [ 'shape' => 'KnowledgeBaseConfigurations', ], 'conversationHistory' => [ 'shape' => 'ConversationHistory', ], ], ], 'SessionStatus' => [ 'type' => 'string', 'enum' => [ 'ACTIVE', 'EXPIRED', 'ENDED', ], ], 'SessionSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'SessionSummary', ], ], 'SessionSummary' => [ 'type' => 'structure', 'required' => [ 'sessionId', 'sessionArn', 'sessionStatus', 'createdAt', 'lastUpdatedAt', ], 'members' => [ 'sessionId' => [ 'shape' => 'Uuid', ], 'sessionArn' => [ 'shape' => 'SessionArn', ], 'sessionStatus' => [ 'shape' => 'SessionStatus', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], 'lastUpdatedAt' => [ 'shape' => 'DateTimestamp', ], ], ], 'SessionTTL' => [ 'type' => 'integer', 'box' => true, 'max' => 3600, 'min' => 60, ], 'Source' => [ 'type' => 'string', 'enum' => [ 'ACTION_GROUP', 'KNOWLEDGE_BASE', 'PARSER', ], 'sensitive' => true, ], 'Span' => [ 'type' => 'structure', 'members' => [ 'start' => [ 'shape' => 'SpanStartInteger', ], 'end' => [ 'shape' => 'SpanEndInteger', ], ], ], 'SpanEndInteger' => [ 'type' => 'integer', 'box' => true, 'min' => 0, ], 'SpanStartInteger' => [ 'type' => 'integer', 'box' => true, 'min' => 0, ], 'StartFlowExecutionRequest' => [ 'type' => 'structure', 'required' => [ 'flowIdentifier', 'flowAliasIdentifier', 'inputs', ], 'members' => [ 'flowIdentifier' => [ 'shape' => 'FlowIdentifier', 'location' => 'uri', 'locationName' => 'flowIdentifier', ], 'flowAliasIdentifier' => [ 'shape' => 'FlowAliasIdentifier', 'location' => 'uri', 'locationName' => 'flowAliasIdentifier', ], 'flowExecutionName' => [ 'shape' => 'FlowExecutionName', ], 'inputs' => [ 'shape' => 'FlowInputs', ], 'modelPerformanceConfiguration' => [ 'shape' => 'ModelPerformanceConfiguration', ], ], ], 'StartFlowExecutionResponse' => [ 'type' => 'structure', 'members' => [ 'executionArn' => [ 'shape' => 'FlowExecutionIdentifier', ], ], ], 'StopFlowExecutionRequest' => [ 'type' => 'structure', 'required' => [ 'flowIdentifier', 'flowAliasIdentifier', 'executionIdentifier', ], 'members' => [ 'flowIdentifier' => [ 'shape' => 'FlowIdentifier', 'location' => 'uri', 'locationName' => 'flowIdentifier', ], 'flowAliasIdentifier' => [ 'shape' => 'FlowAliasIdentifier', 'location' => 'uri', 'locationName' => 'flowAliasIdentifier', ], 'executionIdentifier' => [ 'shape' => 'FlowExecutionIdentifier', 'location' => 'uri', 'locationName' => 'executionIdentifier', ], ], ], 'StopFlowExecutionResponse' => [ 'type' => 'structure', 'required' => [ 'status', ], 'members' => [ 'executionArn' => [ 'shape' => 'FlowExecutionIdentifier', ], 'status' => [ 'shape' => 'FlowExecutionStatus', ], ], ], 'StopSequences' => [ 'type' => 'list', 'member' => [ 'shape' => 'String', ], 'max' => 4, 'min' => 0, ], 'StreamingConfigurations' => [ 'type' => 'structure', 'members' => [ 'streamFinalResponse' => [ 'shape' => 'Boolean', ], 'applyGuardrailInterval' => [ 'shape' => 'StreamingConfigurationsApplyGuardrailIntervalInteger', ], ], ], 'StreamingConfigurationsApplyGuardrailIntervalInteger' => [ 'type' => 'integer', 'box' => true, 'min' => 1, ], 'String' => [ 'type' => 'string', ], 'SummaryText' => [ 'type' => 'string', 'max' => 25000000, 'min' => 0, ], 'SyntheticTimestamp_date_time' => [ 'type' => 'timestamp', 'timestampFormat' => 'iso8601', ], 'TagKey' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '[a-zA-Z0-9\\s._:/=+@-]*', ], 'TagKeyList' => [ 'type' => 'list', 'member' => [ 'shape' => 'TagKey', ], 'max' => 200, 'min' => 1, ], 'TagResourceRequest' => [ 'type' => 'structure', 'required' => [ 'resourceArn', 'tags', ], 'members' => [ 'resourceArn' => [ 'shape' => 'TaggableResourcesArn', 'location' => 'uri', 'locationName' => 'resourceArn', ], 'tags' => [ 'shape' => 'TagsMap', ], ], ], 'TagResourceResponse' => [ 'type' => 'structure', 'members' => [], ], 'TagValue' => [ 'type' => 'string', 'max' => 256, 'min' => 0, 'pattern' => '[a-zA-Z0-9\\s._:/=+@-]*', ], 'TaggableResourcesArn' => [ 'type' => 'string', 'max' => 1011, 'min' => 20, 'pattern' => '.*(^arn:aws(-[^:]+)?:bedrock:[a-zA-Z0-9-]+:[0-9]{12}:(session)/[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}$).*', ], 'TagsMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'TagKey', ], 'value' => [ 'shape' => 'TagValue', ], 'max' => 200, 'min' => 1, ], 'Temperature' => [ 'type' => 'float', 'box' => true, 'max' => 1, 'min' => 0, ], 'TextInferenceConfig' => [ 'type' => 'structure', 'members' => [ 'temperature' => [ 'shape' => 'Temperature', ], 'topP' => [ 'shape' => 'TopP', ], 'maxTokens' => [ 'shape' => 'MaxTokens', ], 'stopSequences' => [ 'shape' => 'RAGStopSequences', ], ], ], 'TextPrompt' => [ 'type' => 'structure', 'required' => [ 'text', ], 'members' => [ 'text' => [ 'shape' => 'TextPromptTextString', ], ], 'sensitive' => true, ], 'TextPromptTemplate' => [ 'type' => 'string', 'max' => 4000, 'min' => 1, 'sensitive' => true, ], 'TextPromptTextString' => [ 'type' => 'string', 'max' => 200000, 'min' => 1, ], 'TextResponsePart' => [ 'type' => 'structure', 'members' => [ 'text' => [ 'shape' => 'String', ], 'span' => [ 'shape' => 'Span', ], ], 'sensitive' => true, ], 'TextToSqlConfiguration' => [ 'type' => 'structure', 'required' => [ 'type', ], 'members' => [ 'type' => [ 'shape' => 'TextToSqlConfigurationType', ], 'knowledgeBaseConfiguration' => [ 'shape' => 'TextToSqlKnowledgeBaseConfiguration', ], ], ], 'TextToSqlConfigurationType' => [ 'type' => 'string', 'enum' => [ 'KNOWLEDGE_BASE', ], ], 'TextToSqlKnowledgeBaseConfiguration' => [ 'type' => 'structure', 'required' => [ 'knowledgeBaseArn', ], 'members' => [ 'knowledgeBaseArn' => [ 'shape' => 'KnowledgeBaseArn', ], ], ], 'ThrottlingException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'NonBlankString', ], ], 'error' => [ 'httpStatusCode' => 429, 'senderFault' => true, ], 'exception' => true, ], 'TopK' => [ 'type' => 'integer', 'box' => true, 'max' => 500, 'min' => 0, ], 'TopP' => [ 'type' => 'float', 'box' => true, 'max' => 1, 'min' => 0, ], 'Trace' => [ 'type' => 'structure', 'members' => [ 'guardrailTrace' => [ 'shape' => 'GuardrailTrace', ], 'preProcessingTrace' => [ 'shape' => 'PreProcessingTrace', ], 'orchestrationTrace' => [ 'shape' => 'OrchestrationTrace', ], 'postProcessingTrace' => [ 'shape' => 'PostProcessingTrace', ], 'routingClassifierTrace' => [ 'shape' => 'RoutingClassifierTrace', ], 'failureTrace' => [ 'shape' => 'FailureTrace', ], 'customOrchestrationTrace' => [ 'shape' => 'CustomOrchestrationTrace', ], ], 'sensitive' => true, 'union' => true, ], 'TraceElements' => [ 'type' => 'structure', 'members' => [ 'agentTraces' => [ 'shape' => 'AgentTraces', ], ], 'sensitive' => true, 'union' => true, ], 'TraceId' => [ 'type' => 'string', 'max' => 16, 'min' => 2, ], 'TraceKnowledgeBaseId' => [ 'type' => 'string', 'sensitive' => true, ], 'TracePart' => [ 'type' => 'structure', 'members' => [ 'sessionId' => [ 'shape' => 'SessionId', ], 'trace' => [ 'shape' => 'Trace', ], 'callerChain' => [ 'shape' => 'CallerChain', ], 'eventTime' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'collaboratorName' => [ 'shape' => 'Name', ], 'agentId' => [ 'shape' => 'AgentId', ], 'agentAliasId' => [ 'shape' => 'AgentAliasId', ], 'agentVersion' => [ 'shape' => 'AgentVersion', ], ], 'event' => true, 'sensitive' => true, ], 'TransformationConfiguration' => [ 'type' => 'structure', 'required' => [ 'mode', ], 'members' => [ 'mode' => [ 'shape' => 'QueryTransformationMode', ], 'textToSqlConfiguration' => [ 'shape' => 'TextToSqlConfiguration', ], ], ], 'Type' => [ 'type' => 'string', 'enum' => [ 'ACTION_GROUP', 'AGENT_COLLABORATOR', 'KNOWLEDGE_BASE', 'FINISH', 'ASK_USER', 'REPROMPT', ], ], 'UntagResourceRequest' => [ 'type' => 'structure', 'required' => [ 'resourceArn', 'tagKeys', ], 'members' => [ 'resourceArn' => [ 'shape' => 'TaggableResourcesArn', 'location' => 'uri', 'locationName' => 'resourceArn', ], 'tagKeys' => [ 'shape' => 'TagKeyList', 'location' => 'querystring', 'locationName' => 'tagKeys', ], ], ], 'UntagResourceResponse' => [ 'type' => 'structure', 'members' => [], ], 'UpdateSessionRequest' => [ 'type' => 'structure', 'required' => [ 'sessionIdentifier', ], 'members' => [ 'sessionMetadata' => [ 'shape' => 'SessionMetadataMap', ], 'sessionIdentifier' => [ 'shape' => 'SessionIdentifier', 'location' => 'uri', 'locationName' => 'sessionIdentifier', ], ], ], 'UpdateSessionResponse' => [ 'type' => 'structure', 'required' => [ 'sessionId', 'sessionArn', 'sessionStatus', 'createdAt', 'lastUpdatedAt', ], 'members' => [ 'sessionId' => [ 'shape' => 'Uuid', ], 'sessionArn' => [ 'shape' => 'SessionArn', ], 'sessionStatus' => [ 'shape' => 'SessionStatus', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], 'lastUpdatedAt' => [ 'shape' => 'DateTimestamp', ], ], ], 'Usage' => [ 'type' => 'structure', 'members' => [ 'inputTokens' => [ 'shape' => 'Integer', ], 'outputTokens' => [ 'shape' => 'Integer', ], ], 'sensitive' => true, ], 'Uuid' => [ 'type' => 'string', 'pattern' => '[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}', ], 'ValidationException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'NonBlankString', ], ], 'error' => [ 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'VectorSearchBedrockRerankingConfiguration' => [ 'type' => 'structure', 'required' => [ 'modelConfiguration', ], 'members' => [ 'modelConfiguration' => [ 'shape' => 'VectorSearchBedrockRerankingModelConfiguration', ], 'numberOfRerankedResults' => [ 'shape' => 'VectorSearchBedrockRerankingConfigurationNumberOfRerankedResultsInteger', ], 'metadataConfiguration' => [ 'shape' => 'MetadataConfigurationForReranking', ], ], ], 'VectorSearchBedrockRerankingConfigurationNumberOfRerankedResultsInteger' => [ 'type' => 'integer', 'box' => true, 'max' => 100, 'min' => 1, ], 'VectorSearchBedrockRerankingModelConfiguration' => [ 'type' => 'structure', 'required' => [ 'modelArn', ], 'members' => [ 'modelArn' => [ 'shape' => 'BedrockRerankingModelArn', ], 'additionalModelRequestFields' => [ 'shape' => 'AdditionalModelRequestFields', ], ], ], 'VectorSearchRerankingConfiguration' => [ 'type' => 'structure', 'required' => [ 'type', ], 'members' => [ 'type' => [ 'shape' => 'VectorSearchRerankingConfigurationType', ], 'bedrockRerankingConfiguration' => [ 'shape' => 'VectorSearchBedrockRerankingConfiguration', ], ], ], 'VectorSearchRerankingConfigurationType' => [ 'type' => 'string', 'enum' => [ 'BEDROCK_RERANKING_MODEL', ], ], 'Verb' => [ 'type' => 'string', 'sensitive' => true, ], 'Version' => [ 'type' => 'string', 'max' => 5, 'min' => 1, 'pattern' => '(DRAFT|[0-9]{0,4}[1-9][0-9]{0,4})', ], ],];
